% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_post_table_deduplication}
\alias{enhancements_post_table_deduplication}
\title{Create a Table Deduplication Enhancement}
\usage{
enhancements_post_table_deduplication(
  name,
  input_field_mapping,
  schedule = NULL,
  parent_id = NULL,
  notifications = NULL,
  input_table = NULL,
  output_table = NULL,
  max_matches = NULL,
  threshold = NULL
)
}
\arguments{
\item{name}{string required. The name of the enhancement job.}

\item{input_field_mapping}{list required. The column mapping for the input table. See /enhancements/field_mapping for list of valid fields.}

\item{schedule}{list optional. A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}

\item{parent_id}{integer optional. Parent ID that triggers this enhancement.}

\item{notifications}{list optional. A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}

\item{input_table}{list optional. A list containing the following elements: 
\itemize{
\item databaseName string, The Redshift database name for the table.
\item schema string, The schema name for the table.
\item table string, The table name.
}}

\item{output_table}{list optional. A list containing the following elements: 
\itemize{
\item databaseName string, The Redshift database name for the table.
\item schema string, The schema name for the table.
\item table string, The table name.
}}

\item{max_matches}{integer optional. The maximum number of matches per record in the input table to return. Must be between 0 and 10. 0 returns all matches.}

\item{threshold}{number optional. The score threshold (between 0 and 1). Matches below this threshold will not be returned.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement job.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{parentId}{integer, Parent ID that triggers this enhancement.}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{inputFieldMapping}{list, The column mapping for the input table. See /enhancements/field_mapping for list of valid fields.}
\item{inputTable}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The Redshift database name for the table.
\item schema string, The schema name for the table.
\item table string, The table name.
}}
\item{outputTable}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The Redshift database name for the table.
\item schema string, The schema name for the table.
\item table string, The table name.
}}
\item{maxMatches}{integer, The maximum number of matches per record in the input table to return. Must be between 0 and 10. 0 returns all matches.}
\item{threshold}{number, The score threshold (between 0 and 1). Matches below this threshold will not be returned.}
}
\description{
Create a Table Deduplication Enhancement
}
