% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarkeTest.R
\name{clarke_test}
\alias{clarke_test}
\title{Clarke Test}
\usage{
clarke_test(model1, model2, level=0.05, digits=2)
}
\arguments{
\item{model1}{A fitted statistical model of a supported class}

\item{model2}{A fitted statistical model of a supported class
whose dependent variable is the same as that of \code{model1}}

\item{level}{Numeric: significance level for the test.}

\item{digits}{Integer: number of digits to print}
}
\value{
Typical use will be to run the function interactively and examine
the printed output.  The functions return an object of class
\code{nonnest.test}, which is a list containing: \describe{
\item{\code{stat}}{The test statistic}
\item{\code{level}}{Significance level for the test}
\item{\code{digits}}{Number of digits to print}
\item{\code{loglik1}}{Vector of observationwise log-likelihoods for
\code{model1}}
\item{\code{loglik2}}{Vector of observationwise log-likelihoods for
\code{model2}}
\item{\code{nparams}}{Integer vector containing the number of parameters
fitted in \code{model1} and \code{model2} respectively}
\item{\code{nobs}}{Number of observations of the dependent variable being
modeled}}
}
\description{
`clarke_test` returns results from Kevin Clarke's distribution-free test
of non-nested models.
}
\details{
`clarke_test` is a more modularized version of the [clarke()] function from
the [games] package.  The main innovation is that the `nonnest` function
calls a generic `indivLogLiks` function, so additional methods can be easily
written for different classes of models. The function
currently supports binomial, poisson and negative
binomial GLMs, ordinal models estimated with either
\code{polr} from the \code{MASS} package
or \code{clm} from the \code{ordinal}
package and multinomial models estimated with either
\code{multinom} from the \code{nnet}
package.  Users can also write new
methods for both \code{indivLogLiks} and \code{nparams}
that would get called by the generic function.
}
\examples{
data(conflictData)
## Linear Model
lm1 <- lm(riots ~ log(rgdpna_pc) + log(pop*1000) +
    polity2, data=conflictData)
lm2 <- lm(riots ~ rgdpna_pc + pop +
    polity2, data=conflictData)
clarke_test(lm1, lm2)

## Binomial GLM
glm1 <- glm(conflict_binary ~ log(rgdpna_pc) +
          log(pop*1000) + polity2, data=conflictData,
          family=binomial)
glm2 <- glm(conflict_binary ~ rgdpna_pc + pop +
          polity2, data=conflictData,
          family=binomial)
clarke_test(glm1, glm2)

## Poisson GLM
glm1a <- glm(riots ~ log(rgdpna_pc) +
              log(pop*1000) + polity2,
             data=conflictData,
             family=poisson)
glm2a <- glm(riots ~ rgdpna_pc + pop +
              polity2, data=conflictData,
            family=poisson)
clarke_test(glm1a, glm2a)

## Negative Binomial GLM
library(MASS)
glm1b <- glm.nb(riots ~ log(rgdpna_pc) +
               log(pop*1000) + polity2,
               data=conflictData)
glm2b <- glm.nb(riots ~ rgdpna_pc + pop +
               polity2, data=conflictData)
clarke_test(glm1b, glm2b)

## Ordered Logit: polr
library(MASS)
ol1 <- polr(as.factor(Amnesty) ~ log(rgdpna_pc) +
                  log(pop*1000) + polity2,
                data=conflictData)
ol2 <- polr(as.factor(Amnesty) ~ scale(rgdpna_pc) +
            scale(pop) + polity2,
            data=conflictData)
clarke_test(ol1, ol2)

## Ordered Logit: clm
library(ordinal)
ol1a <- clm(as.factor(Amnesty) ~ log(rgdpna_pc) +
              log(pop*1000) + polity2,
            data=conflictData)
ol2a <- clm(as.factor(Amnesty) ~ scale(rgdpna_pc) +
            scale(pop) + polity2,
            data=conflictData)
clarke_test(ol1a, ol2a)

## Multinomial Logit: multinom

library(nnet)
ml1 <- multinom(as.factor(Amnesty) ~ log(rgdpna_pc) +
              log(pop*1000) + polity2,
            data=conflictData)
ml2 <- multinom(as.factor(Amnesty) ~ scale(rgdpna_pc) +
              scale(pop) + polity2,
            data=conflictData)
clarke_test(ml1, ml2)


## Multinomial Logit: multinom


}
\references{
Kevin Clarke.  2007.  "A Simple Distribution-Free Test for
Nonnested Hypotheses."  \emph{Political Analysis} 15(3): 347--363.
}
\author{
Brenton Kenkel (\email{brenton.kenkel@gmail.com}) modified by
Dave Armstrong (\email{dave@quantoid.net})
}
