% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_interval.R
\name{animate_interval}
\alias{animate_interval}
\title{Generate animated plot}
\usage{
animate_interval(obj, interval)
}
\arguments{
\item{obj}{A \emph{cleanTS} object.}

\item{interval}{A numeric or character, specifying the viewing interval.}
}
\value{
A list containing:
\itemize{
\item animation: A \code{gganim} object.
\item nstates: The number of states in the animation.
}
}
\description{
\code{animate_interval()} creates an animated plot using a \code{cleanTS} object
and a interval.
}
\examples{
# Convert sunspots.month to dataframe
data <- timetk::tk_tbl(sunspot.month)

# Randomly insert missing values to simulate missing value imputation
set.seed(10)
ind <- sample(nrow(data), 100)
data$value[ind] <- NA

# Perform cleaning
cts <- cleanTS(data, date_format = "my", time = "index", value = "value")

# Create a `gganim` using `animate_interval()` function
a <- animate_interval(cts, "10 year")


}
