% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{check_package}
\alias{check_package}
\title{Check a Package}
\usage{
check_package(path, pattern = "\\\\.[rR]$", ...)
}
\arguments{
\item{path}{Path to the package to be checked.}

\item{pattern}{A pattern to search files with, see \code{\link{list.files}}.}

\item{...}{Arguments to be passed to \code{\link{check_file}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}},
but see \emph{Details}.
}
\description{
Run \code{\link{check_file}} on a package's source.
}
\details{
The function catches the messages of "cleanr"-conditions
\code{\link{throw}}n by \code{\link{check_file}} and, if it caught any,
\code{\link{throw}}s them.
}
\examples{
# create a fake package first:
package_path <- file.path(tempdir(), "fake")
usethis::create_package(package_path, fields = NULL,
                        rstudio = FALSE, open = FALSE)
directory <- system.file("runit_tests", "source", "R_s4",
                         package = "cleanr") 
file.copy(list.files(directory, full.names = TRUE), file.path(package_path,
                                                              "R"))
RUnit::checkTrue(cleanr::check_package(package_path, check_return = FALSE))
}
