\name{numExpSimData-dataset}
\docType{data}
\alias{numExpSimData}
\alias{numExpSimData-dataset}

\title{Performances of 9 methods for dimension reduction on data simulated under the CLERE model}

\description{
  This dataset is a matrix of 200 rows and 28 colums. The columns can be
  grouped as three blocs of 9 (for each method compared: \code{LASSO}, \code{RIDGE},
  Elastic net [\code{ELNET}], Stepwise variable selection [\code{STEP}], \code{CLERE}, CLERE
  sparse [\code{CLERE_s}], Spike and Slab [\code{SS}], \code{AVG} method and Pairwise
  Absolute Clustering and Sparsity [\code{PACS}]). Prediction errors (MSE),
  number of estimated parameters and time (seconds) to fit the data are
  compared.The 1st 9 (1:9) contain prediction error obtained by 5-fold
  cross validation using 10 random permutation of the covariate
  matrix. The 2nd 9 columns (10:18) contain the number of parameters
  estimated for each method. The 3rd 9 columns are times in seconds
  measured for fitting each methods. The 28 column is the seed utilized
  for generating random numbers in these analyses. Each row corresponds
  to a simulated dataset on which all 9 methods were fitted. For more
  details, please refer to the package vignette. 
}

\usage{
 data(numExpSimData)
}

\format{
  A 200 x 28 matrix.
}

\seealso{
  Overview  : \code{\link{clere-package}} \cr
  Classes   : \code{\linkS4class{Clere}}, \code{\linkS4class{Pacs}} \cr
  Functions : \code{\link{fitClere}}, \code{\link{fitPacs}} \cr
  Datasets  : \code{\link{numExpRealData}}, \code{\link{numExpSimData}}, \code{\link{algoComp}}
}

\author{Loic Yengo \email{loic.yengol@gmail.com}}

\keyword{datasets}
\keyword{numExpSimData}
\keyword{clere}
