% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDD.R
\name{GDD}
\alias{GDD}
\title{Growing degree-days}
\usage{
GDD(object, day.one = NULL, degree.days = NULL, base = 10, span = 150, ...)
}
\arguments{
\item{object}{a numeric vector of geographic coordinates (lonlat) or
an array with two dimensions containing the temperature data;
1st dimension contains the day temperature and 2nd dimension the night
temperature. When lonlat is used, the function makes a call to
\code{nasapower::get_power()} to fetch and concatenate environmental
data from NASA POWER (\url{https://power.larc.nasa.gov/}) for the parameters
T2M_MAX (Maximum Temperature at 2 m) and 
T2M_MIN (Minimum Temperature at 2 m)}

\item{day.one}{a vector of class \code{Date} for the starting date to 
capture the environmental data (YYYY-MM-DD)}

\item{degree.days}{an integer for the degree-days required by the 
organism (look for the physiology of the focal organism)}

\item{base}{an integer for the base temperature}

\item{span}{an integer or a vector with integers for the duration 
of the timespan to be captured}

\item{...}{additional arguments passed to 
\code{\link[nasapower]{get_power}} methods}
}
\value{
The number of days required to reach the growing degree-days.
}
\description{
Compute number of days required to reach Growing degree-days.
GDD is a heuristic tool in phenology that measures heat 
accumulation and is used to predict plant and animal development 
rates. Growing degree-days are calculated by taking the 
integral of warmth above a base temperature.
}
\examples{
# Using local sources
data("modis", package = "climatrends")

day <- as.Date("2013-10-28", format = "\%Y-\%m-\%d")

GDD(modis, 
    day.one = day,
    degree.days = 100, 
    base = 5,
    span = 13)

\donttest{
# Using NASA POWER
library("nasapower")

set.seed(123)
# random geographic locations around bbox(11, 12, 55, 58)
lonlat <- data.frame(lon = runif(3, 11, 12),
                     lat = runif(3, 55, 58))

set.seed(321)
# random dates around 2018-05-15 and 2018-05-20
dates <- as.integer(runif(3, 17666, 17670))
dates <- as.Date(dates, origin = "1970-01-01")

# Calculate the days required for the plants in these plots to reach the
# maturity. Here the plant species requires ~1300 degree days for it.
GDD(lonlat, 
    day.one = dates,
    degree.days = 1300,
    base = 5)
}

}
\references{
Prentice I. C., et al. (1992) Journal of Biogeography, 19(2), 117. 
\cr\url{https://doi.org/10.2307/2845499}
}
\seealso{
Other climatology functions: 
\code{\link{ETo}()},
\code{\link{rainfall}()},
\code{\link{temperature}()}
}
\concept{climatology functions}
