% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDD.R
\name{GDD}
\alias{GDD}
\alias{GDD.default}
\alias{GDD.data.frame}
\alias{GDD.array}
\alias{GDD.sf}
\title{Growing degree-days}
\usage{
GDD(object, ..., tbase = 10)

\method{GDD}{default}(object, tmin, ..., tbase = 10)

\method{GDD}{data.frame}(object, day.one, ..., tbase = 10)

\method{GDD}{array}(object, day.one, ..., tbase = 10)

\method{GDD}{sf}(object, day.one, ..., tbase = 10, as.sf = TRUE)
}
\arguments{
\item{object}{a numeric vector with the maximum temperature, 
or a data.frame with geographical coordinates (lonlat), 
or an object of class \code{sf} with geometry 'POINT' or 'POLYGON', 
or an \code{array} with two dimensions containing the
maximum and minimum temperature, in that order. See details}

\item{...}{additional arguments passed to methods. See details}

\item{tbase}{an integer for the minimum temperature for growth}

\item{tmin}{a numeric vector with the minimum temperature}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}

\item{as.sf}{logical, to return an object of class 'sf'}
}
\value{
The number of days to reach the accumulated \var{degree.days} or the daily degree-days 
  as defined with the argument \var{return.as}
}
\description{
This a heuristic tool in phenology that measures heat accumulation and 
is used to predict plant and animal development rates. Growing degree-days
are calculated by taking the integral of warmth above a base temperature.
}
\details{
Additional arguments:

\code{equation} character to specify the equation to be used, one of \code{"default"},
\code{"a"}, \code{"b"} or \code{"c"}. See Equations below 

\code{tbase_max} optional, the maximum tbase temperature, 
 required if \code{equation = "c"}   

\code{return.as} character (one of, the default, \code{"acc"} or \code{"daily"},
 \code{"ndays"}) to select if the function returns the accumulated gdd, or the 
 daily values of gdd across the series, or the number of days required to reach a
 certain number of \code{degree.days}
 
\code{degree.days} an integer for the accumulated degree-days required by the 
 organism. Optional if \var{return.as = "daily"} or \var{return.as = "acc"} 

\code{last.day}: an object (optional to \var{span}) of class \code{Date} or
 any other object that can be coerced to \code{Date} (e.g. integer, character 
 YYYY-MM-DD) for the last day of the time series. For \code{data.frame}, 
 \code{array} and \code{sf} methods
 
\code{span}: an integer (optional to \var{last.day}) or a vector with 
 integers (optional if \var{last.day} is given) for the length of 
 the time series to be captured. For \code{data.frame}, \code{array} 
 and \code{sf} methods

S3 Methods:

The \code{array} method assumes that \var{object} contains climate data available 
 in your R section; this requires an array with two dimensions, 1st dimension 
 contains the day temperature and 2nd dimension the night temperature, 
 see help("temp_dat", package = "climatrends") for an example on input structure.

The \code{data.frame} and \code{sf} methods assumes that the climate data
 will e fetched from a remote (cloud) source that be adjusted using the argument 
 \var{data.from}

 
Equations: 
 
 \code{"default"}: GDD = ((tmax + tmin) / 2) - tbase
 
 \code{"a"}: adjust tmean = tbase if tmeam < tbase
 
 \code{"b"}: adjust tmin = tbase if tmin < tbase,
  adjust tmax = tbase if tmax < tbase
 
 \code{"c"}: adjust tmin = tbase if tmin < tbase, 
  adjust tmax = tbase_max if tmax < tbase_max
}
\examples{
data("innlandet", package = "climatrends")

# use the default equation
GDD(innlandet$tmax, innlandet$tmin, tbase = 2)

# set the equation "b", which is a better option for this case
# tmin = tbase if tmin < tbase 
# tmax = tbase if tmax < tbase
GDD(innlandet$tmax, innlandet$tmin, tbase = 2, equation = "b")


#####################################################

# return as the number of days required to reach a certain accumulated GDD
# use equation "c", which adjusts tmax base on a tbase_max
data("temp_dat", package = "climatrends")

GDD(temp_dat, 
    day.one = "2013-10-27", 
    degree.days = 90, 
    return.as = "ndays", 
    tbase_max = 32,
    equation = "c")

}
\references{
Prentice I. C., et al. (1992) Journal of Biogeography, 19(2), 117. 
\doi{https://doi.org/10.2307/2845499}

Baskerville, G., & Emin, P. (1969). Ecology, 50(3), 514-517. 
\doi{https://doi.org/10.2307/1933912}
}
\seealso{
Other temperature functions: 
\code{\link{ETo}()},
\code{\link{crop_sensitive}()},
\code{\link{temperature}()}

Other GDD functions: 
\code{\link{late_frost}()}
}
\concept{GDD functions}
\concept{temperature functions}
