% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-formatDataForPlotClinData.R
\name{formatDataForPlotClinData}
\alias{formatDataForPlotClinData}
\title{Format data for interactive plot for clinical data}
\usage{
formatDataForPlotClinData(
  data,
  hoverVars = NULL,
  hoverLab = getLabelVar(hoverVars, labelVars = labelVars),
  hoverByVar = NULL,
  keyVar = NULL,
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  labelVars = NULL
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{hoverVars}{Character vector with variable(s) to be displayed in the hover,
by default any position and aesthetic variables displayed in the plot.}

\item{hoverLab}{Named character vector with labels for \code{hoverVars}.}

\item{hoverByVar}{Character vector with variables identifying
unique elements in the plot, usually x, y, facet variables.
These variables are used to identify records with the same position
in the plot, their information are combined in the hover.}

\item{keyVar}{String with unique key variable, identifying unique
group for which the link between the table and the plot should be done.}

\item{id}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{labelVars}{Named character vector containing variable labels.}
}
\value{
\code{\link[crosstalk]{SharedData}} object containing the \code{data},
with an extra column: 'hover' with the combined info from \code{hoverVars},
and the key defined as \code{keyVar} and group as \code{id}.
}
\description{
Format data for interactive plot for clinical data
}
\author{
Laure Cougnaud
}
