% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clogitLasso.R
\name{clogitLasso}
\alias{clogitLasso}
\title{fit lasso for conditional logistic regression for matched case-control studies}
\usage{
clogitLasso(X, y, strata, fraction = NULL, nbfraction = 100,
  nopenalize = NULL, BACK = TRUE, standardize = FALSE, maxit = 100,
  maxitB = 500, thr = 1e-10, tol = 1e-10, epsilon = 1e-04,
  trace = TRUE, log = TRUE, adaptive = FALSE, separate = FALSE,
  ols = FALSE, p.fact = NULL, remove = FALSE)
}
\arguments{
\item{X}{Input matrix, of dimension nobs x nvars; each row is an observation vector}

\item{y}{Binary response variable, with 1 for cases and 0 for controls}

\item{strata}{Vector with stratum membership of each observation}

\item{fraction}{Sequence of lambda values}

\item{nbfraction}{The number of lambda values - default is 100}

\item{nopenalize}{List of coefficients not to penalize starting at 0}

\item{BACK}{If TRUE, use Backtracking-line search -default is TRUE}

\item{standardize}{Logical flag for x variable standardization, prior to fitting the model sequence.}

\item{maxit}{Maximum number of iterations of outer loop - default is 100}

\item{maxitB}{Maximum number of iterations  in Backtracking-line search - default is 100}

\item{thr}{Threshold for convergence in lassoshooting. Default value is 1e-10. Iterations stop when max absolute parameter change is less than thr}

\item{tol}{Threshold for convergence-default value is 1e-10}

\item{epsilon}{ratio of smallest to largest value of regularisation parameter  at which we find parameter estimates}

\item{trace}{If TRUE the algorithm will print out information as iterations  proceed -default is TRUE}

\item{log}{If TRUE, fraction are spaced uniformily on the log scale}

\item{adaptive}{If TRUE adaptive lasso is fitted-default is FALSE}

\item{separate}{If TRUE, the weights in adaptive lasso are build serarately using univariate models. Default is FALSE,
weights are build using multivariate model}

\item{ols}{If TRUE, weights less than 1 in adaptive lasso are set to 1. Default is FALSE}

\item{p.fact}{Weights for adaptive lasso}

\item{remove}{If TRUE, invariable covariates are removed-default is FALSE}
}
\value{
An object of type \code{clogitLasso} which is a list with the following
components:

\item{beta}{nbfraction-by-ncol matrix of estimated coefficients. First row has all 0s}

\item{fraction}{A sequence of regularisation parameters at which we obtained the fits}

\item{nz}{A vector of length nbfraction containing the number of nonzero parameter estimates for
 the fit at the corresponding regularisation parameter}

 \item{arg}{List of arguments}
}
\description{
Fit a sequence of conditional logistic regression with lasso penalty,for small to large sized samples
}
\details{
The sequence of models implied by fraction  is fit by  IRLS (iteratively
 reweighted least squares) algorithm.
 by coordinate descent with warm starts and sequential strong rules
}
\examples{
#generate data
 y = rep(c(1,0), 100)
 X = matrix (rnorm(20000, 0, 1), ncol = 100) # pure noise
 strata = sort(rep(1:100, 2))

 # 1:1
 fitLasso = clogitLasso(X,y,strata,log=TRUE)
}
\author{
Marius Kwemou and Marta Avalos
}
\references{
Avalos, M., Pouyes, H., Grandvalet, Y., Orriols, L., & Lagarde, E. (2015). \emph{Sparse conditional logistic
 regression for analyzing large-scale matched data from epidemiological studies: a simple algorithm.} BMC bioinformatics, 16(6), 1.
}

