% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcloud-storage.R
\name{gs_data_dir_local}
\alias{gs_data_dir_local}
\title{Get a local path to the contents of Google Storage bucket}
\usage{
gs_data_dir_local(url, local_dir = "gs", echo = FALSE)
}
\arguments{
\item{url}{Google Storage bucket URL (e.g. \code{gs://<your-bucket>}).}

\item{local_dir}{Local directory to synchonize Google Storage bucket(s) to.}

\item{echo}{Echo command output to console.}
}
\value{
Local path to contents of bucket.
}
\description{
Provides a local filesystem interface to Google Storage buckets. Many
package functions accept only local filesystem paths as input (rather than
gs:// URLs). For these cases the \code{gcloud_path()} function will synchronize
gs:// buckets to the local filesystem and provide a local path interface
to their contents.
}
\details{
If you pass a local path as the \code{url} it will be returned
unmodified. This allows you to for example use a training flag for the
location of data which points to a local directory during
development and a Google Cloud bucket during cloud training.
}
\note{
For APIs that accept gs:// URLs directly (e.g. TensorFlow datasets)
you should use the \code{\link[=gs_data_dir]{gs_data_dir()}} function.
}
\seealso{
\code{\link[=gs_data_dir]{gs_data_dir()}}
}
