% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{fix_empty}
\alias{fix_empty}
\title{Certify that, given enough points, no clusters are left empty}
\usage{
fix_empty(clu_num_points, allow_empty = FALSE)
}
\arguments{
\item{clu_num_points}{Number of points in each cluster (vector of size
\mjseqn{c}), where \mjseqn{c} is the number of clusters.}

\item{allow_empty}{Allow empty clusters?}
}
\value{
Number of points in each cluster, after being fixed by this function
(vector of size \mjseqn{c}).
}
\description{
\loadmathjax
Certifies that, given enough points, no clusters are left empty. This is done
by removing a point from the largest cluster and adding it to an empty
cluster while there are empty clusters. If the total number of points is
smaller than the number of clusters (or if the \code{allow_empty} parameter is set
to \code{TRUE}), this function does nothing.
}
\details{
This function is used internally by \link{clusizes} and might be useful for custom
cluster sizing implementations given as the \code{clusizes_fn} parameter of the
main \link{clugen} function.
}
\examples{
clusters <- c(3, 4, 5, 0, 0)    # A vector with some empty elements
clusters <- fix_empty(clusters) # Apply this function
clusters                        # Check that there's no more empty elements
}
