data_dir <- file.path("..", "testdata")
tempfile_nc <- function() {
  tempfile_helper("timcor_")
}

########## output ncdf version 3 ##########
file_in_1 <- file.path(data_dir, "ex_tim_cor_covar_1.nc")
file_in_2 <- file.path(data_dir, "ex_tim_cor_covar_2.nc")
file_out <- tempfile_nc()
timcor("SIS", file_in_1, "SIS", file_in_2, file_out)
file <- nc_open(file_out)

test_that("data is correct", {
  actual <- ncvar_get(file)
  
  expected_data <- c(-5.5782625E-4,1.0,0.36880052,-0.21945444,0.024656009,0.3919665,0.18898223,0.29244202,-0.84468776,-0.15258467,-0.48380375,0.7006521,-0.2773501,0.6856796,-0.1335394,-0.010631545,-0.84468776,0.8635261,-0.09344876,0.041769814,-0.19640386,
                     1.0,-0.48211178,-0.45063862,-0.1739618,-0.98351645,0.9777347,-0.8926907,-0.8065013,-0.33707008,-0.03524854,0.18536986,-0.09283592,0.068299085,-0.028855493,0.50264007,-0.28349566,-1.0,-0.34961608,0.37820396,0.14034185,0.75010705,
                     -0.09384527,0.2606476,-0.4271211,-0.5676224,0.46230024,-0.16934855,-0.31679273,0.012593903,0.2107567,0.551816,-0.5345454,0.61164296,-0.43355498,-0.06049483,-0.541621,-0.40316075,0.64937556,-0.031108,0.6185896,0.17535868,-0.14250743,
                     -0.68727785,-0.68108153,0.781151,0.47725716,0.1713099,0.24291058,0.088398986,-0.28532156,0.7634559,-0.5616177,0.068510264,0.013363396,0.18739271,0.27624124,0.3801882,0.4014357,0.42503616,-0.22695188,-0.79408365,-0.7281435,-1.0,
                     -0.31346822,0.41227135,-0.60509074,-0.5658092,1.0,-0.046760976,-0.011623717,-0.03361305,-0.3126438,0.48832807,-0.6215889,0.41931394,-0.6850748,-0.1707717,0.2404302,-1.0,-0.8302808,0.25610217,-0.7637848,-0.001371377,-0.66912377,
                     0.21529487,0.101360604,-0.14908427,-0.9539963,0.32216415,1.0,0.2280373,0.4816518,0.26686823,0.051870827,-0.46274605,0.2414031,0.8685465,-1.0,-0.3973597,0.6747895,0.90184724,0.29428476,-0.099725,-0.6360235,0.20387836,
                     -0.72702265,0.40395337,-0.6401643,-0.3592106,-0.45778006,-0.24209864,0.51329434,-1.0,-0.79941523,-0.3183113,0.2720965,0.30495808,-0.10964376,0.73672384,0.15783498,0.8064565,-1.0,-0.15840296,0.29136577,-0.28484413,0.09376281,
                     -0.7265669,-0.002328019,1.0,0.27577835,0.81954885,0.8058374,0.19752486,0.3792386,-0.7258231,1.0,0.82503533,0.13700394,-0.38463867,-0.51638997,-0.5801951,0.24944448,-0.5731387,0.6892855,0.052414242,-0.47424623,-0.033294808,
                     0.42040667,0.98304474,-0.12597704,0.4323604,0.14776987,0.3549717,0.19975775,-0.53905874,-0.6576075,0.9252672,0.4323604,0.5262301,-0.048151128,0.71625835,-0.23542367,-2.5311278E-4,0.31898886,-0.49919894,-0.7415815,-0.827928,0.31322733,
                     -1.0,-0.51675606,0.25383654,-0.13162424,-0.29542497,1.0,-0.011702245,0.43355498,0.22986425,0.2532031,0.17177574,-0.011711894,-0.048788387,-0.39720795,-0.9595082,-0.78354204,0.6735419,-0.18590009,0.19033785,-0.10973566,0.25953954,
                     1.0,0.35572055,-0.004713011,0.55114305,0.08681816,0.95214796,-0.39899808,0.64490205,-0.5150727,0.84937954,-0.099102065,0.14285715,-0.7038178,0.15700871,-0.7910055,-0.6151432,-0.060707927,0.7064963,0.42411664,-0.35613227,-0.27206984,
                     0.9539629,0.58152306,0.73074484,0.35305128,0.08359487,0.07409726,0.17370184,0.36429703,0.4518534,-0.4729881,-0.9964688,-0.38991874,0.08741337,-0.101360604,-0.043643367,0.37719068,1.0,-0.5846935,-0.4287667,-0.35052451,0.52129644,
                     -0.11773835,-0.43369013,0.101360604,-0.3145704,0.54219365,0.5603179,-1.0,0.19670255,0.20751679,0.47152975,-0.33713186,-0.28390095,-0.20161118,0.78054863,0.05857731,0.20156446,0.54219365,-0.7717015,-0.069259845,0.42810366,-0.30689237,
                     0.22259407,0.3531717,-0.68586254,-1.0,-0.4080421,-0.65581673,-0.08847479,-1.0,0.04120428,0.4201688,0.1853337,0.09839212,-0.34482422,0.037981696,-0.41022012,-0.47295564,0.8199414,-0.024618851,-0.32587168,-0.43355498,-0.034543578,
                     0.18052603,0.093780205,-0.7065409,-0.039910648,-0.59982795,0.55149597,-0.6920626,0.25612655,0.50525385,-0.89049226,0.38175514,0.21936451,0.2113842,-0.5725304,-0.45658413,0.8292289,0.57987106,-1.0,-0.099884994,-1.0,0.29356962,
                     -0.33184046,-0.20896721,-0.63320804,0.68324345,-0.8105754,0.84129524,-0.55624473,0.17806844,-0.04186771,0.058200393,-0.03394221,-0.16400412,0.20647156,0.12453387,0.7281795,0.90344304,-0.015899586,0.5666553,-0.19971785,-0.55562365,0.28754306,
                     0.53602546,-0.075929485,-0.83264667,-0.22661088,0.26689458,-0.78390837,0.30850807,0.9764159,-0.5061098,-0.44225442,-0.6204701,0.56031483,-0.28833845,-1.0,-0.92415136,-0.05763904,-0.44785225,-1.0,-1.0,-0.8252133,-0.6384081,
                     0.34452218,0.23236448,0.60537004,0.14543581,1.0,0.79510254,0.16183269,0.24133196,-0.32836908,-0.028855493,-0.26751843,-0.35773072,-0.7894933,-0.51030844,0.21507266,0.7150092,-1.0,0.78505963,0.28050628,0.86378825,0.5866024,
                     0.00452228,0.1076083,-0.42654145,-0.17206661,0.29904702,-1.0,0.18271391,0.15945402,-0.5496834,-0.5583574,-0.28976768,0.15774609,-0.5643399,0.38972306,-0.20028608,0.3709965,-0.6856796,-0.73779595,1.0,0.2767863,0.29506585,
                     -0.0039816946,0.40389034,0.4694719,-1.0,0.34277916,0.43911254,-1.0,0.65789974,-0.03846154,1.0,0.16484141,-0.38904345,0.5020483,0.12095055,0.7175448,-0.31569567,-0.18453951,0.057686955,-0.9011886,0.91118085,0.4885069,
                     0.31501687,0.4881436,0.998296,0.2907419,1.0,-0.08847479,-0.96436113,0.51090807,-0.57071835,-0.6981826,0.57206106,-0.5828664,-0.21208146,-1.0,0.042272843,-0.5108293,0.17108722,-0.6875792,0.7065392,0.4568956,-0.7073008
                     
  )
  expected <- array(expected_data, dim = c(21, 21))
  
  expect_equivalent(actual, expected)
})

test_that("attributes are correct", {
  actual <- ncatt_get(file, "lon", "units")$value
  expect_equal(actual, "degrees_east")
  
  actual <- ncatt_get(file, "lon", "long_name")$value
  expect_equal(actual, "longitude")
  
  actual <- ncatt_get(file, "lon", "standard_name")$value
  expect_equal(actual, "longitude")
  
  actual <- ncatt_get(file, "lon", "axis")$value
  expect_equal(actual, "X")
  
  actual <- ncatt_get(file, "lat", "units")$value
  expect_equal(actual, "degrees_north")
  
  actual <- ncatt_get(file, "lat", "long_name")$value
  expect_equal(actual, "latitude")
  
  actual <- ncatt_get(file, "lat", "standard_name")$value
  expect_equal(actual, "latitude")
  
  actual <- ncatt_get(file, "lat", "axis")$value
  expect_equal(actual, "Y")
  
  actual <- ncatt_get(file, "time", "units")$value
  expect_equal(actual, "hours since 1983-01-01 00:00:00")
  
  actual <- ncatt_get(file, "time", "long_name")$value
  expect_equal(actual, "time")
  
  actual <- ncatt_get(file, "time", "standard_name")$value
  expect_equal(actual, "time")
  
  actual <- ncatt_get(file, "time", "calendar")$value
  expect_equal(actual, "standard")
  
  actual <- ncatt_get(file, "SIS", "standard_name")$value
  expect_equal(actual, "SIS_standard")
  
  actual <- ncatt_get(file, "SIS", "long_name")$value
  expect_equal(actual, "Surface Incoming Shortwave Radiation")
  
  actual <- ncatt_get(file, "SIS", "units")$value
  expect_equal(actual, "W m-2")
  
  actual <- ncatt_get(file, "SIS", "_FillValue")$value
  expect_equal(actual, -999)
  
  actual <- ncatt_get(file, "SIS", "cmsaf_info")$value
  expect_equal(actual, "cmsaf::timcor for variable SIS")
  
  global_attr <- ncatt_get(file, 0)
  expect_equal(length(global_attr), 1)
  
  actual <- names(global_attr[1])
  expect_equal(actual, "Info")
  
  actual <- global_attr[[1]]
  expect_equal(actual, "Created with the CM SAF R Toolbox.")
})

test_that("coordinates are correct", {
  actual <- ncvar_get(file, "lon")
  expect_identical(actual, array(seq(5, 15, 0.5)))
  
  actual <- ncvar_get(file, "lat")
  expect_identical(actual, array(seq(45, 55, 0.5)))
  
  actual <- ncvar_get(file, "time")
  expect_equal(actual, array(151920))
})

nc_close(file)
