% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooling.R
\name{pool_austria}
\alias{pool_austria}
\title{Pool surveys from different pollsters}
\usage{
pool_austria(
  ...,
  pollsters = c("Market", "Research Affairs", "Unique Research", "OGM", "IMAS", "Hajek",
    "Gallup", "Karmasin")
)
}
\arguments{
\item{pollsters}{Character vector of pollsters that should be considered
for pooling.}
}
\description{
Per default, pools surveys starting from current date and going 14 days back.
For each pollster within the defined time-frame, only the most recent survey
is used.
}
\examples{
library(coalitions)
library(dplyr)
latest <- get_latest(surveys_sample)
pool_surveys(surveys_sample, last_date=as.Date("2017-09-02"))
}
\seealso{
pool_surveys
}
\keyword{internal}
