% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/common_tools.R
\name{df_scale_ols}
\alias{df_scale_ols}
\title{Scales variables in data.frame dfx using ordinary least squares such}
\usage{
df_scale_ols(dfx, dfy)
}
\arguments{
\item{dfx}{data.frame, Data frame to use as independent variable}

\item{dfy}{data.frame, Data frames to use as dependent variable}
}
\value{
data.frame, A rescaled version of dfx with dimnames from dfy.
}
\description{
Scales variables in data.frame dfx using ordinary least squares such that the scaled
result explains as much of the variance in dfy as possible.
Scaling is done separately for each variable (i.e. no linear mixing of variables).
Assumes data.frames dfx and dfy to be of identical structure.
Intended use: to scale up cocoreg projections to account for the lost variance.
}
\examples{
\dontrun{
dc <- create_syn_data_toy()
ccr <- cocoreg(dc$data)
dfLst <- mapply(df_scale_ols, ccr$data, dc$data , SIMPLIFY=F)
}
}

