% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoreg.R
\name{matrix_variability}
\alias{matrix_variability}
\title{Compute "variance" of the matrices using Frobenius norm.
Variance is by default computed with respect to the mean of the matrices.}
\usage{
matrix_variability(mat_lst, mean_mat = apply(abind::abind(mat_lst, along = 3),
  c(1, 2), mean))
}
\arguments{
\item{mat_lst}{A [1,M] list of [I,J] matrices from which variability should
be computed}

\item{mean_mat}{A [I,J] matrix describing the mean observation for mat_lst.}
}
\value{
A list with elements
\item{fbnorm}{Frobenius norm values for each of the matrices}
\item{diff}{[I,J,M] matrix of differences mat_lst-mean_mat}
}
\description{
Compute "variance" of the matrices using Frobenius norm.
Variance is by default computed with respect to the mean of the matrices.
}
