% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_tools.R
\name{traverse_nested_list}
\alias{traverse_nested_list}
\title{Apply fun to the bottom level of a nested list structure}
\usage{
traverse_nested_list(lst, fun, exclude_names = NULL, ...)
}
\arguments{
\item{lst}{nested list, A nested list structure to process}

\item{fun}{function object, The function to apply at the bottom level}

\item{exclude_names}{string array, Names of list elements to skip at any level}

\item{...}{Further parameters passed on to fun}
}
\value{
A list outputs generated when applying fun to the bottom level of input lst.
Bottom level is considered reached when something other than class == 'list' is 
encountered.
}
\description{
Used to batch process computation results that are stored into a nested list structure.
Analysis results are stored as lists but with class attribute changed. This signals that the
recursion into the list structure should end and fun should be applied instead. Can be used e.g. 
to pick out results from a complex list structure.
}
