% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{compute_reliabilities}
\alias{compute_reliabilities}
\title{Compute reliabilities}
\usage{
compute_reliabilities(results, survey_repetition = "single")
}
\arguments{
\item{results}{a formr results table with attributes set on items and scales}

\item{survey_repetition}{defaults to "single". Can also be "repeated_once" or "repeated_many"}
}
\description{
If you pass the object resulting from a call to formr_results to this function, it will compute reliabilities for each scale.
Internally, each reliability computation is passed to a \code{\link[future:future]{future::future()}}.
If you are calculating multilevel reliabilities, it may be worthwhile to
parallelise this operation using \code{\link[future:plan]{future::plan()}}.
If you don't plan on any complicated parallelisation, you probably do not
need to call this function directly, but can rely on it being automatically
called during codebook generation.
If you do plan to do that, you can pass the results of this operation to the codebook function.
}
\examples{
data("bfi", package = "codebook")
  bfi <- bfi \%>\% dplyr::select(dplyr::starts_with("BFIK_agree"))
reliabilities <- compute_reliabilities(bfi)
}
