% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.r
\name{multiplot}
\alias{multiplot}
\title{Plot multiple coefplots}
\usage{
multiplot(..., title = "Coefficient Plot", xlab = "Value",
  ylab = "Coefficient", innerCI = 1, outerCI = 2, lwdInner = 1,
  lwdOuter = 0, pointSize = 3, dodgeHeight = 1, color = "blue",
  shape = 16, linetype = 1, cex = 0.8, textAngle = 0,
  numberAngle = 90, zeroColor = "grey", zeroLWD = 1, zeroType = 2,
  single = TRUE, scales = "fixed", ncol = length(unique(modelCI$Model)),
  sort = c("natural", "normal", "magnitude", "size", "alphabetical"),
  decreasing = FALSE, names = NULL, numeric = FALSE, fillColor = "grey",
  alpha = 1/2, horizontal = FALSE, factors = NULL, only = NULL,
  shorten = TRUE, intercept = TRUE, interceptName = "(Intercept)",
  coefficients = NULL, predictors = NULL, strict = FALSE,
  newNames = NULL, plot = TRUE, drop = FALSE, by = c("Coefficient",
  "Model"), plot.shapes = FALSE, plot.linetypes = FALSE,
  legend.position = c("right", "left", "bottom", "top", "none"),
  secret.weapon = FALSE, legend.reverse = FALSE, trans = identity)
}
\arguments{
\item{\dots}{Models to be plotted}

\item{title}{The name of the plot, if NULL then no name is given}

\item{xlab}{The x label}

\item{ylab}{The y label}

\item{innerCI}{How wide the inner confidence interval should be, normally 1 standard deviation.  If 0, then there will be no inner confidence interval.}

\item{outerCI}{How wide the outer confidence interval should be, normally 2 standard deviations.  If 0, then there will be no outer confidence interval.}

\item{lwdInner}{The thickness of the inner confidence interval}

\item{lwdOuter}{The thickness of the outer confidence interval}

\item{pointSize}{Size of coefficient point}

\item{dodgeHeight}{Amount of vertical dodging}

\item{color}{The color of the points and lines}

\item{shape}{The shape of the points}

\item{linetype}{The type of line drawn for the standard errors}

\item{cex}{The text size multiplier, currently not used}

\item{textAngle}{The angle for the coefficient labels, 0 is horizontal}

\item{numberAngle}{The angle for the value labels, 0 is horizontal}

\item{zeroColor}{The color of the line indicating 0}

\item{zeroLWD}{The thickness of the 0 line}

\item{zeroType}{The type of 0 line, 0 will mean no line}

\item{single}{logical; If TRUE there will be one plot with the points and bars stacked, otherwise the models will be displayed in separate facets}

\item{scales}{The way the axes should be treated in a faceted plot.  Can be c("fixed", "free", "free_x", "free_y")}

\item{ncol}{The number of columns that the models should be plotted in}

\item{sort}{Determines the sort order of the coefficients.  Possible values are c("natural", "magnitude", "alphabetical")}

\item{decreasing}{logical; Whether the coefficients should be ascending or descending}

\item{names}{Names for models, if NULL then they will be named after their inputs}

\item{numeric}{logical; If true and factors has exactly one value, then it is displayed in a horizontal graph with continuous confidence bounds.}

\item{fillColor}{The color of the confidence bounds for a numeric factor}

\item{alpha}{The transparency level of the numeric factor's confidence bound}

\item{horizontal}{logical; If the plot should be displayed horizontally}

\item{factors}{Vector of factor variables that will be the only ones shown}

\item{only}{logical; If factors has a value this determines how interactions are treated.  True means just that variable will be shown and not its interactions.  False means interactions will be included.}

\item{shorten}{logical or character; If \code{FALSE} then coefficients for factor levels will include their variable name.  If \code{TRUE} coefficients for factor levels will be stripped of their variable names.  If a character vector of variables only coefficients for factor levels associated with those variables will the variable names stripped.}

\item{intercept}{logical; Whether the Intercept coefficient should be plotted}

\item{interceptName}{Specifies name of intercept it case it is not the default of "(Intercept").}

\item{coefficients}{A character vector specifying which factor coefficients to keep.  It will keep all levels and any interactions, even if those are not listed.}

\item{predictors}{A character vector specifying which coefficients to keep.  Each individual coefficient can be specified.  Use predictors to specify entire factors}

\item{strict}{If TRUE then predictors will only be matched to its own coefficients, not its interactions}

\item{newNames}{Named character vector of new names for coefficients}

\item{plot}{logical; If the plot should be drawn, if false then a data.frame of the values will be returned}

\item{drop}{logical; if TRUE then models without valid coefficients to show will not be plotted}

\item{by}{If "Coefficient" then a normal multiplot is plotted, if "Model" then the coefficients are plotted along the axis with one for each model.  If plotting by model only one coefficient at a time can be selected.  This is called the secret weapon by Andy Gelman.}

\item{plot.shapes}{If \code{TRUE} points will have different shapes for different models}

\item{plot.linetypes}{If \code{TRUE} lines will have different shapes for different models}

\item{legend.position}{position of legend, one of "left", "right", "bottom", "top", "none"}

\item{secret.weapon}{If this is \code{TRUE} and exactly one coefficient is listed in coefficients then Andy Gelman's secret weapon is plotted.}

\item{legend.reverse}{Setting to reverse the legend in a multiplot so that it matches the order they are drawn in the plot}

\item{trans}{A transformation function to apply to the values and confidence intervals.  \code{identity} by default.  Use \code{invlogit} for binary regression.}
}
\value{
A ggplot object
}
\description{
Plot the coeffcients from multiple models
}
\details{
Plots a graph similar to \code{\link{coefplot}} but for multiple plots at once.

For now, if \code{names} is provided the plots will appear in alphabetical order of the names.  This will be adjusted in future iterations.  When setting \code{by} to "Model" and specifying exactly one variable in \code{variables} that one coefficient will be plotted repeatedly with the axis labeled by model.  This is Andy Gelman's secret weapon.
}
\examples{

data(diamonds)
model1 <- lm(price ~ carat + cut, data=diamonds)
model2 <- lm(price ~ carat + cut + color, data=diamonds)
model3 <- lm(price ~ carat + color, data=diamonds)
multiplot(model1, model2, model3)
multiplot(model1, model2, model3, single=FALSE)
multiplot(model1, model2, model3, plot=FALSE)
require(reshape2)
data(tips, package="reshape2")
mod1 <- lm(tip ~ total_bill + sex, data=tips)
mod2 <- lm(tip ~ total_bill * sex, data=tips)
mod3 <- lm(tip ~ total_bill * sex * day, data=tips)
mod7 <- lm(tip ~ total_bill + day + time, data=tips)
multiplot(mod1, mod2, mod3, mod7, single=FALSE, scales="free_x")
multiplot(mod1, mod2, mod3, mod7, single=FALSE, scales="free_x")
multiplot(mod1, mod2, mod3, mod7, single=FALSE, scales="free_x", plot.shapes=TRUE)
multiplot(mod1, mod2, mod3, mod7, single=TRUE, scales="free_x", 
plot.shapes=TRUE, plot.linetypes=TRUE)
multiplot(mod1, mod2, mod3, mod7, single=TRUE, scales="free_x", 
plot.shapes=FALSE, plot.linetypes=TRUE, legend.position="bottom")
# the secret weapon
multiplot(mod1, mod2, mod3, mod7, coefficients="total_bill", secret.weapon=TRUE)
# horizontal secret weapon
multiplot(mod1, mod2, mod3, mod7, coefficients="total_bill", by="Model", horizontal=FALSE)


}
\seealso{
\code{link{coefplot}}
}
