\name{batch.mpaircomp}
\alias{batch.mpaircomp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
batch analysis to explore coexistence density for different scenarios of a pair of parameters, for the case of multiple species modeling
}
\description{
batch version for the function sta.mpaircomparison()
}
\usage{
batch.mpaircomp(coexistlist,coenum,spnum,parameters)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{coexistlist}{
list of data generated by batch.mcoexistence() function
}
  \item{coenum}{
coexisting species number in a patch you want to explore across the scenarios. Should be >=2 and <=total species number
}
  \item{spnum}{
number of species in the model
}
  \item{parameters}{
a parameter sampling point vector,for example parameters=c(.2,.5,.9), indicating three sampling points in a single
parameter. The function will thus compare the coexistence patch numbers under the cases when each of the pairwise parameters (for example,
growth rate and the competition ability of a species)=0.2,0.5 and 0.9 respectively.
}
}

\references{
Chen YH (2012) coexist: an R package for performing species coexistence modeling and analysis under asymmetric dispersal and fluctuating source-sink dynamics.
http://code.google.com/p/coexist.
}
\author{
Youhua Chen <yhchen@zoology.ubc.ca>
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{sta.mcomparison}}, 
\code{\link{sta.mpaircomparison}}
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (coexistlist,coenum,spnum,parameters)
{
    if (is.list(coexistlist)) {
        scenarionum <- length(coexistlist)
        pairlist <- list()
        length(pairlist) <- scenarionum
        for (i in 1:scenarionum) {
            pairlist[[i]] <- sta.mpaircomparison(coexistlist[[i]], 
                coenum, spnum = spnum, parameters = parameters)
        }
        return(pairlist)
    }
  }
}
