% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-indic.R
\name{GraphIndicators}
\alias{GraphIndicators}
\title{Graph indicators of a social cognitive map}
\usage{
GraphIndicators(project, filters = NULL, units = "all",
  weighted.icm = FALSE)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{filters}{A list of named strings that will filter the relationships showed in the SCM. e.g. =list(coding_class = "A_coding_class", document_part = "A_document_part")=. To date, these filters are linked to the nature of relationships.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}

\item{weighted.icm}{A boolean. If FALSE, the weight of the relationships in the ICM will be fixed to 1.}
}
\value{
A data frame with the value of some indicators linked to the map
}
\description{
Compute the graph indicators of a Social Cognitive Map (at graph level)
}
\details{
Compute some indicators from the graph theory and applies them to a Social Cognitive Map :
\itemize{
\item dimension : the number of vertices
\item n_transmitter : the number of transmitter vertices
\item n_receiver : the number of receiver vertices
\item n_ordinary : the number of ordinary vertices (transmitter & receiver)
\item connections : the number of edges
\item density : ...
\item complexity_a : ....
\item complexity_b : ...
\item hierarchy : ...
}

(== add formulae ==)

Source : Oezesmi & Oezesmi, 2004
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

GraphIndicators(my.project)
GraphIndicators(my.project, units = "Belgium")
GraphIndicators(my.project, units = "Québec")
}
