% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{get_crypto_meta}
\alias{get_crypto_meta}
\title{Get static metdata}
\usage{
get_crypto_meta(symbol = NULL, id = NULL, slug = NULL)
}
\arguments{
\item{symbol}{One or more cryptocurrency symbols.
Example: c("BTC","ETH").}

\item{id}{Alternatively pass one or more CoinMarketCap cryptocurrency IDs.
Example: c(1,2)}

\item{slug}{Alternatively pass a vector of exchange slugs.
Example: c("binance","cryptsy")}
}
\value{
A dataframe with metadata of Cryptocurrencies
}
\description{
Get all static metdata available for one or more cryptocurrencies
}
\note{
At least one "id" or "slug" or "symbol" is required for this request.
}
\examples{
\dontrun{
get_crypto_meta()
get_crypto_meta(symbol = c("BTC","ETH"))
get_crypto_meta(id = c(1,2,3,4))
get_crypto_meta(slug = c("bitcoin", "ethereum"))
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1CryptocurrencyInfo}{API documentation}
}
\seealso{
Other Cryptocurrencies: 
\code{\link{get_crypto_listings}()},
\code{\link{get_crypto_map}()},
\code{\link{get_crypto_marketpairs}()},
\code{\link{get_crypto_ohlcv}()},
\code{\link{get_crypto_quotes}()},
\code{\link{get_marketcap_ticker_all}()},
\code{\link{get_valid_currencies}()}
}
\concept{Cryptocurrencies}
