% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deque.R
\docType{data}
\name{DequeL}
\alias{DequeL}
\title{Double Ended Queue (list based)}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
DequeL
}
\description{
The \code{DequeL} class creates a double ended queue with list backend.
Pure R implementation, mainly for benchmark.
}
\section{Usage}{

\preformatted{
DequeL$new(items = NULL)
DequeL$push(item)
DequeL$pushleft(item)
DequeL$pop()
DequeL$popleft()
DequeL$peek()
DequeL$peekleft()
DequeL$extend(q)
DequeL$extendleft(q)
DequeL$clear()
DequeL$remove(item)
DequeL$size()
DequeL$as_list()
}
}

\section{Arguments}{

\itemize{
\item \code{items}: initialization list
\item \code{item}: any R object
\item \code{q}: a DequeL object
}
}

\examples{
q <- DequeL$new()
q$push("foo")
q$push("bar")
q$pushleft("baz")
q$pop()  # bar
q$popleft()  # baz

q <- DequeL$new(list("foo", "bar"))
q$push("baz")$pushleft("bla")
}
\seealso{
\link{Deque}
}
\keyword{datasets}
