% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-to-head.R
\name{h2h_long}
\alias{h2h_long}
\alias{to_h2h_long}
\alias{as_tibble.h2h_long}
\title{Compute long format of Head-to-Head values}
\usage{
h2h_long(cr_data, ..., fill = list())

to_h2h_long(mat, value = "h2h_value", drop = FALSE)

\method{as_tibble}{h2h_long}(x, ...)
}
\arguments{
\item{cr_data}{Competition results ready for \code{\link[=as_longcr]{as_longcr()}}.}

\item{...}{Name-value pairs of Head-to-Head functions (see Details).}

\item{fill}{A named list that for each variable supplies a single value to
use instead of \code{NA} for missing pairs (see tidyr's
\link[tidyr:complete]{complete()}).}

\item{mat}{Matrix of Head-to-Head values.}

\item{value}{String name to be used for column with Head-to-Head value.}

\item{drop}{Use \code{TRUE} to drop rows with missing Head-to-Head values (see
Details).}

\item{x}{Object to be converted to \link[tibble:tibble]{tibble}.}
}
\value{
An object of class \code{h2h_long} which is a \link[tibble:tibble]{tibble}
with columns \code{player1}, \code{player2} and those, produced by Head-to-Head
functions (for \code{h2h_long()} maybe none).

\link[tibble:as_tibble]{as_tibble()} applied to \code{h2h_long} object drops
\code{h2h_long} class.
}
\description{
Functions to compute Head-to-Head values in long pair-value format.
}
\details{
\code{h2h_long()} computes Head-to-Head values in
\link[=convert-pair-value]{long} format. It allows computation of multiple
Head-to-Head values at the same time by supplying multiple summary functions
in \code{...}. If no function is supplied in \code{...}, it returns all appropriate
combinations of \link[=get_matchups]{matchups} (see next paragraph).

After computing Head-to-Head values of actually present matchups, they are
aligned with "levels" (see \code{\link[=levels2]{levels2()}}) of \code{player} vector (after applying
\code{as_longcr()}). This is a way to target function on fixed set of players by
using factor columns. The procedure is:
\itemize{
\item Implicit missing matchups are turned into explicit (by adding corresponding
rows with filling values in Head-to-Head columns) by using tidyr's
\link[tidyr:complete]{complete()}.
\item All matchups not containing players from "levels" are removed.
}

Use \code{fill} as in \code{complete()} to control filling values. To drop those rows
use tidyr's \link[tidyr:drop_na]{drop_na()}.

\code{to_h2h_long()} takes \strong{object of \link{h2h_mat} structure} and converts
it into \code{h2h_long} object with value column named as stored in \code{value}. Use
\code{drop = TRUE} to remove rows with missing values in value column (but not in
players').
}
\section{Head-to-Head value}{

Head-to-Head value is a summary statistic of direct confrontation between two
players. It is assumed that this value can be computed based only on the
players' \link[=get_matchups]{matchups}. In other words, every game is converted
into series of "subgames" between ordered pairs of players (including
selfplay) which is stored as \link{widecr} object. After that, summary of item,
defined by columns \code{player1} and \code{player2}, is computed using
\code{\link[=summarise_item]{summarise_item()}}.

That said, name-value pairs of Head-to-Head functions should be defined as
for \code{summarise_item()} applied to data with columns \code{game}, \code{player1},
\code{score1}, \code{player2}, \code{score2}.
}

\examples{
ncaa2005 \%>\%
  h2h_long(
    mean_score = mean(score1),
    mean_abs_score = mean(abs(score1 - score2))
  )

ncaa2005[-(1:2), ] \%>\%
  h2h_long(
    mean_score = mean(score1),
    fill = list(mean_score = 0)
  )
}
\seealso{
\link[=h2h_mat]{Matrix format} of Head-to-Head values.

\link[=h2h_funs]{Common Head-to-Head functions}.
}
