% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_json_data.R
\name{ct_json_data}
\alias{ct_json_data}
\title{UN Comtrade data extraction via JSON}
\usage{
ct_json_data(url, colname)
}
\arguments{
\item{url}{Complete url string of the call to the API.}

\item{colname}{Indication as to whether to use "human friendly" col names or
"machine friendly" col names. Value will be either "H" or "M".}
}
\value{
List of length three, elements are:
 \itemize{
 \item \code{msg}: Brief message on success/failure of the API call.
 \item \code{details}: More detailed message on success/failure of the API
   call.
 \item \code{data}: Dataframe object of return data.
 }
}
\description{
Function makes an API call to UN Comtrade, data is returned from the API as
a JSON object. Return value of this function is a list containing the data
as a dataframe and information on whether the connection to the API was
successful, and whether or not data was returned from the API. For use with
the UN Comtrade API, full API docs can be found at
\url{https://comtrade.un.org/data/doc/api/}
}
