% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachment.R
\name{confl_attachment}
\alias{confl_attachment}
\alias{confl_list_attachments}
\alias{confl_post_attachment}
\alias{confl_update_attachment_metadata}
\alias{confl_update_attachment_data}
\title{CRUD Operations for Attachments on Content}
\usage{
confl_list_attachments(
  id,
  filename = NULL,
  mediaType = NULL,
  start = 0,
  limit = 50,
  expand = NULL
)

confl_post_attachment(id, path)

confl_update_attachment_metadata(id, attachmentId, ...)

confl_update_attachment_data(id, attachmentId, path, ...)
}
\arguments{
\item{id}{The ID of a page that attachments belong to.}

\item{filename}{Filter parameter to return only the Attachment with the matching file name. Optional.}

\item{mediaType}{Filter parameter to return only Attachments with a matching Media-Type. Optional.}

\item{start}{The start point of the collection to return.}

\item{limit}{The limit of the number of items to return, this may be restricted by fixed system limits.}

\item{expand}{A comma separated list of properties to expand. To refer the nested
contents, use periods. (e.g. \verb{body.storage,history}).}

\item{path}{Path to a file to upload.}

\item{attachmentId}{The ID of an attachment.}

\item{...}{Other arguments passed to 'query'.}
}
\value{
The API response as a list.
}
\description{
CRUD Operations for Attachments on Content
}
\examples{
\dontrun{
# Create a dummy text file
tmp_txt <- tempfile(fileext = ".txt")
cat("foo", file = tmp_txt)

# Upload the file to a page whose ID is "123"
confl_post_attachment("123", tmp_txt)

# Confirm the file is attatched to the page
result <- confl_list_attachments("123", filename = basename(tmp_txt))
length(result$results) # should be 1
}

}
