% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cham_bill_info.R
\name{cham_bill_info}
\alias{cham_bill_info}
\title{Downloads details of a specific bill by providing type, number and year}
\usage{
cham_bill_info(type, number, year, ascii = T)
}
\arguments{
\item{type}{\code{character}. The type of the bill. For example, "PL"}

\item{number}{\code{integer}. The number of the bill}

\item{year}{\code{integer}. The year of the bill.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads details of a specific bill by providing type, number and year
}
\note{
Requesting data from a long period of time with \code{details = TRUE} will
return a large object in terms of memory. It will also be rather unwieldy, with
many columns.
}
\examples{
cham_bill_info(type = "PL", number = "3962", year = "2008")
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
