% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_votes.R
\name{sen_votes}
\alias{sen_votes}
\title{Returns voting information from the Senate floor for the date
requested}
\usage{
sen_votes(date = NULL, end_date = NULL, binary = TRUE, ascii = TRUE)
}
\arguments{
\item{date}{\code{character} or \code{integer}. Format YYYYMMDD.}

\item{end_date}{\code{character} or \code{integer}. Format YYYYMMDD. If
\code{end_date} is supplied, information on all votes between the initial date
(\code{date}) and \code{end_date} is returned. See the notes below.}

\item{binary}{\code{logical}. If \code{TRUE}, the default, transforms
votes into \code{1} for "yes", \code{0}, for "no" and \code{NA} for everything
else. If \code{FALSE}, returns a character vector of vote decisions.}

\item{ascii}{\code{logical}. If \code{TRUE}, the default, strips Latin
characters from the results.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Returns voting information from the Senate floor for the date
requested.
}
\note{
The maximum period allowed by the API is currently 60 days. If the
period requested is larger than this, an error message is returned. For a full
set of votes for each legislature, see \code{data("senate_nominal_votes")}.
}
\examples{
\dontrun{
sen_votes(date = "20130516")

# Some votes are secret:
ssshhh <- sen_votes("20160301", binary = FALSE)

# All votes between two periods (might take a little while):
longer <- sen_votes(date = "20160301", end_date = "20160415")
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
