% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{connect}
\alias{connect}
\title{Create a connection to Posit Connect}
\usage{
connect(
  server = Sys.getenv(paste0(prefix, "_SERVER"), NA_character_),
  api_key = Sys.getenv(paste0(prefix, "_API_KEY"), NA_character_),
  prefix = "CONNECT",
  ...,
  .check_is_fatal = TRUE
)
}
\arguments{
\item{server}{The URL for accessing Posit Connect. Defaults to environment
variable CONNECT_SERVER}

\item{api_key}{The API Key to authenticate to Posit Connect with. Defaults
to environment variable CONNECT_API_KEY}

\item{prefix}{The prefix used to determine environment variables}

\item{...}{Additional arguments. Not used at present}

\item{.check_is_fatal}{Whether to fail if "check" requests fail. Useful in
rare cases where more http request customization is needed for requests to
succeed.}
}
\value{
A Posit Connect R6 object that can be passed along to methods
}
\description{
Creates a connection to Posit Connect using the server URL and an api key.
Validates the connection and checks that the version of the server is
compatible with the current version of the package.
}
\examples{
\dontrun{
connect()
}

\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# default is to read CONNECT_SERVER and CONNECT_API_KEY environment variables
# this example will read TEST_1_SERVER and TEST_1_API_KEY
connect(prefix = "TEST_1")
\dontshow{\}) # examplesIf}
}
