% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coords.R
\name{get_coords}
\alias{get_coords}
\title{Get the coordinates of the textbox object}
\usage{
get_coords(x)
}
\arguments{
\item{x}{A textbox object}
}
\value{
A list of coordinates will return:
\item{left}{Left (x-min) side coordinate.}
\item{right}{Right (x-max) side coordinate.}
\item{bottom}{Bottom (y-min) side coordinate.}
\item{top}{Top (y-max) side coordinate.}
\item{top.mid }{Coordinate vector of top middle, measured by grob.}
\item{left.mid}{Coordinate vector of left middle, measured by grob.}
\item{bottom.mid}{Coordinate vector of bottom middle, measured by grob.}
\item{right.mid}{Coordinate vector of right middle, measured by grob.}
\item{x}{X (center x) coordinate.}
\item{y}{Y (center y) coordinate.}
\item{width}{Width of the textbox, derived with \code{grobWidth}.}
\item{height}{Height of the textbox, derived with \code{grobHeight}.}
\item{half_width}{Half width of the box.}
\item{half_height}{Half height of the box.}
}
\description{
This function will get the coordinates of the textbox object.
}
\examples{
fg <- textbox(text = "This is a test")
get_coords(fg)
}
