% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeBlock.append.R
\name{timeBlock.append}
\alias{timeBlock.append}
\title{Append TimeBlock Information to a Data Frame}
\usage{
timeBlock.append(
  x = NULL,
  dateTime = NULL,
  blockLength = 1,
  blockUnit = "hours",
  blockingStartTime = NULL
)
}
\arguments{
\item{x}{Data frame containing dateTime information, and to which block 
information will be appended. if NULL, dateTime input relies solely on 
the dateTime argument.}

\item{dateTime}{Vector of length nrow(x) or singular character data, 
detailing the relevant colname in x, that denotes what dateTime 
information will be used. If argument == NULL, the function assumes a 
column with the colname "dateTime" exists in x. Defaults to NULL.}

\item{blockLength}{Integer. Describes the number of blockUnits within each 
temporal block. Defaults to 1.}

\item{blockUnit}{Character string taking the values, "secs," "mins," 
"hours," "days," or "weeks." Defaults to "hours."}

\item{blockingStartTime}{Character string or date object describing the date
OR dateTime starting point of the first time block. For example, if 
blockingStartTime = "2016-05-01" OR "2016-05-01 00:00:00", the first 
timeblock would begin at "2016-05-01 00:00:00." If NULL, the 
blockingStartTime defaults to the minimum dateTime point in x. Note: 
any blockingStartTime MUST precede or be equivalent to the minimum 
timepoint in x. Additional note: If blockingStartTime is a character 
string, it must be in the format ymd OR ymd hms.}
}
\value{
Appends the following columns to \code{x}.
   
   \item{block}{Integer ID describing unique blocks of time of pre-specified
   length.}
   \item{block.start}{The timepoint in \code{x} at which the \code{block}
   begins.}
   \item{block.end}{The timepoint in \code{x} at which the \code{block}
   ends.}
   \item{numBlocks}{Integer describing the total number of time blocks 
   observed within \code{x} at which the \code{block}}
}
\description{
Appends "block," "block.start," "block.end," and "numBlocks" columns to an 
   input data frame (x) with a dateTime (see dateTime.append) column. This 
   allows users to "block" data into blockLength-blockUnit-long 
   (e.g., 10-min-long) temporal blocks. If x == NULL, the function output 
   will be a data frame with "dateTime" and block-related columns.
}
\details{
This is a sub-function that can be found in the contactDur functions.
}
\examples{
data("calves")
calves.dateTime<-datetime.append(calves, date = calves$date, 
   time = calves$time) #add dateTime identifiers for location fixes.
calves.block<-timeBlock.append(x = calves.dateTime, 
    dateTime = calves.dateTime$dateTime, blockLength = 10, 
    blockUnit = "mins")
head(calves.block) #see that block information has been appended.
}
\keyword{data-processing}
\keyword{sub-function}
