% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek.R
\name{peek}
\alias{peek}
\alias{peekleft}
\alias{peek.Deque}
\alias{peekleft.Deque}
\title{Peek at Left or Right of a Deque}
\usage{
peekleft(x, default = NULL)

peek(x, default = NULL)

\method{peek}{Deque}(x, default = NULL)

\method{peekleft}{Deque}(x, default = NULL)
}
\arguments{
\item{x}{a \code{Deque} object.}

\item{default}{value to be returned if peeked value does not exist.}
}
\value{
The first (\code{peekleft}) or last (\code{peek}) element.
}
\description{
Try to access first or last element and return some default value if not found.
In contrast to \verb{[at2()]}, this function provides a less stricter element
access, that is, it remains valid even if peeked elements don't exist.
}
\details{
\code{peek} peek at last element of a \code{Deque}.

\code{peekleft} peek at first element of a \code{Deque}.
}
\examples{
# Deque
d = deque(1, 2, 3)
peek(d)
peekleft(d)
peek(deque())
peek(deque(), default = 0)
peekleft(deque(), default = 0)
}
\seealso{
\code{\link[=at2]{at2()}} for strict element extraction
}
