% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_chi_squared_test_1xc.R
\name{Pearson_chi_squared_test_1xc}
\alias{Pearson_chi_squared_test_1xc}
\title{The Pearson chi-squared test for multinomial probabilities}
\usage{
Pearson_chi_squared_test_1xc(n, pi0, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{pi0}{given probabilities (a 1xc vector)}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A data frame containing the two-sided p-value, the statistic and the degrees of freedom
}
\description{
The Pearson chi-squared test for multinomial probabilities

Described in Chapter 3 "The 1xc Table and the Multinomial Distribution"
}
\examples{
# Genotype counts for SNP rs 6498169 in RA patients
Pearson_chi_squared_test_1xc(n = c(276, 380, 118), pi0 = c(0.402, 0.479, 0.119))
# subset of 10 patients
Pearson_chi_squared_test_1xc(n = c(6, 1, 3), pi0 = c(0.402, 0.479, 0.119))
}
