% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Newcombe_square_and_add_CI_paired_2x2.R
\name{Newcombe_square_and_add_CI_paired_2x2}
\alias{Newcombe_square_and_add_CI_paired_2x2}
\title{The Newcombe square-and-add confidence interval for the difference}
\usage{
Newcombe_square_and_add_CI_paired_2x2(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
The Newcombe square-and-add confidence interval for the difference between paired probabilities.

Described in Chapter 8 "The Paired 2x2 Table"
}
\examples{
# Airway hyper-responsiveness before and after stem cell transplantation
# (Bentur et al., 2009)
n <- rbind(c(1, 1), c(7, 12))
Newcombe_square_and_add_CI_paired_2x2(n)

# Complete response before and after consolidation therapy
# (Cavo et al., 2012)
n <- matrix(c(59, 6, 16, 80), 2, byrow = TRUE)
Newcombe_square_and_add_CI_paired_2x2(n)

}
