% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOVER_Wilson_score_CI_paired_2x2.R
\name{MOVER_Wilson_score_CI_paired_2x2}
\alias{MOVER_Wilson_score_CI_paired_2x2}
\title{The MOVER Wilson score confidence interval for the ratio of paired probabilities}
\usage{
MOVER_Wilson_score_CI_paired_2x2(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (F = no, T= yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
The MOVER Wilson score confidence interval for the ratio of paired probabilities

Described in Chapter 8 "The Paired 2x2 Table"
}
\examples{
n <- rbind(c(1, 1), c(7, 12))
MOVER_Wilson_score_CI_paired_2x2(n)

# Complete response before and after consolidation therapy
# (Cavo et al., 2012)
n <- matrix(c(59, 6, 16, 80), 2, byrow = TRUE)
MOVER_Wilson_score_CI_paired_2x2(n)

}
