% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_formulas.R
\name{.plus_to_c}
\alias{.plus_to_c}
\title{Handle \code{+} in formula LHS}
\usage{
.plus_to_c(plus_expr)
}
\arguments{
\item{plus_expr}{Expression}
}
\value{
A new expression where \code{+} is replaced with \code{c()}
}
\description{
Given a formula like cyl + gear ~ sum_code, this function recursively
replaces the \code{+} operators with \code{c} so that the LHS becomes \code{c(cyl, gear)}.
}
\details{
This function doesn't recurse into other function calls, for example:
\code{cyl + gear + factor(1 + 2)} evaluates to \code{c(cyl, gear, factor(1+2))}.
}
\keyword{internal}
