% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncoprimary.R
\name{ncoprimary}
\alias{ncoprimary}
\title{Sample size calculation in clinical trials with two co-primary time-to-event endpoints}
\usage{
ncoprimary(design,Survhyp1,Survhyp2,alpha1,alpha2,duraccrual,durstudy,power,pe,
look,fup,dropout,dqol)
}
\arguments{
\item{design}{Superiority=c(1,sided)[with sided=1 if 1-sided and 2 if 2-sided]; Non inferiority=c(2); Equivalence=c(3)}

\item{Survhyp1}{For Superiority=c(thyp,t,hype,Sc); for Non inferiority=c(thyp,t,hype,Sc,hypeA); for Equivalence=c(t,delta,Sc): parameters at time t for the first endpoint,
if thyp=1 then hype is survival rate or the rate of patients without HRQoL deterioration in experimental arm under the null hypothesis and hypeA is the survival rate in the experimental arm under the alternative hypothesis; 
if thyp=2 then hype is the hazard ratio under the null hypothesis and hypeA is the hazard ratio under the alternative hypothesis; Sc is survival rate in the control arm; 
delta is the log hazard ratio equivalence margin. When endpoint is HRQoL, the survival rate is replaced by the rate of patients without HRQoL deterioration.}

\item{Survhyp2}{For Superiority=c(thyp,t,hype,Sc); for Non inferiority=c(thyp,t,hype,Sc,hypeA); for Equivalence=c(t,delta,Sc): parameters at time t for the second endpoint
if thyp=1 then hype is survival rate in experimental arm under the null hypothesis and hypeA is the survival rate in the experimental arm under the alternative hypothesis; 
if thyp=2 then hype is the hazard ratio under the null hypothesis and hypeA is the hazard ratio under the alternative hypothesis; Sc is survival rate in the control arm; 
delta is the log hazard ratio equivalence margin. When endpoint is HRQoL, the survival rate is replaced by the rate of patients without HRQoL deterioration.}

\item{alpha1}{Type I error assigned to the first endpoint, for Non inferiority, Equivalence and 1-sided superiority is a vector of length one. 
For 2-sided superiority is a vector to length two c(alpha.low, alpha.up).}

\item{alpha2}{Type I error assigned to the second endpoint, for Non inferiority, Equivalence and 1-sided superiority is a vector of length one. 
For 2-sided superiority is a vector to length two c(alpha.low, alpha.up).}

\item{duraccrual}{Accrual duration, expressed in number of days, months or years}

\item{durstudy}{Study duration, expressed in number of days, months or years}

\item{power}{1-Probability of a type II error. Default value = 0.80.}

\item{pe}{Proportion (ratio) of patients assigned to the experimental arm (with 0<pe<1). Default value = 0.50.}

\item{look}{The number of interim analyses, c(1) for one final analysis; c(nb, bound, timing) for at least one interim analyses with bound=c(bound.eff,bound.fut):1-sided or bound=c(bound.low,bound.up):2-sided.
nb the number of planned looks, bound.eff and bound.fut corresponds to the type of boundaries used for efficacy (i.e. reject H0) and futility (i.e. reject H1). 
bound.fut=0: No futility monitoring, 1: Lan deMets O.Brien Fleming, 2: Lan deMets Pocock. 
bound.low and bound.up the type of lower and upper boundaries used (1: Lan deMets O.Brien Fleming, 2: Lan deMets Pocock, 3: O.Brien Fleming, 4: Pocock). Default value = 1.}

\item{fup}{Follow-up information, No fixed:c(0) (follow-up until the end of study); 
Fixed:c(1, durfollow) with durfollow is the duration of follow-up. Default value = 0.}

\item{dropout}{Drop out information, No drop out=c(0); Drop out=c(1,gammae,gammac) with gammae and gammac are the hazard drop out rates in experimental arm 
and control arm respectively. Default value = 0.}

\item{dqol}{number of targeted dimensions for the health related quality of life. Default value = 0.}
}
\value{
Event: number of events estimated

Total: number of patients

Ne: number for experimental arm for each endpoint

Nc: number for control arm for each endpoint

HR: Hazard ratio for each endpoint
}
\description{
ncoprimary() is used to calculate the sample size for phase III clinical trial with two co-primary endpoints to assess the efficacy of treatment between two groups.
}
\details{
The ncoprimary function computes the sample size for two primary endpoints. Both endpoints can be one time to event endpoint and health related quality of life (HRQoL) 
or two times to event endpoints.
}
\examples{

####################################################################################
############ Design superiority:one-sided with two co-primary endpoints ############
####################################################################################
## - For endpoint 1: 3-year survival rates Se=0.75 and Sc=0.65, alpha1=0.02
## - For endpoint 2: 4-year survival rates Se=0.70 and Sc=0.59, alpha2=0.03
## with accrual duration of 2 years, study duration of 4 years and default values i.e 
## power=0.80, pe=0.5, look=1, fup=0, dropout=0, dqol=0 

nc1 <- ncoprimary(design=c(1,1),Survhyp1=c(1,3,0.75,0.65),Survhyp2=c(1,4,0.70,0.59),
alpha1=0.02,alpha2=0.03,duraccrual=2,durstudy=4)


#####################################################################################
 ############ Design superiority:two-sided with two co-primary endpoints ############
#####################################################################################
## - For endpoint 1: 2 target variables for the health related quality of life with 3-year 
## rate without HRQoL deterioration Se=0.75 and Sc=0.67, alpha1=c(0.01,0.01)
## - For endpoint 2: 4-year survival rates Se=0.86 and Sc=0.80, alpha2=c(0.015,0.015)
## with accrual duration of 3 years, study duration of 6 years, power=0.90, look=c(2,c(1,1),0.5), 
## and default values i.e  pe=0.5, fup=0, dropout=0

nc2 <- ncoprimary(design=c(1,2),Survhyp1=c(1,5,0.75,0.67),Survhyp2=c(1,5,0.86,0.80),
alpha1=c(0.01,0.01),alpha2=c(0.015,0.015),duraccrual=3,durstudy=6, power=0.90,
look=c(2,c(1,1),0.5),dqol=2)


#####################################################################################
##############  Design non-inferiority with two co-primary endpoints ################
#####################################################################################
## - For endpoint 1: 3-year survival rates Se=0.75 and Sc=SeA=0.75, alpha1=0.01
## - For endpoint 2: 4-year survival rates Se=0.67 and Sc=SeA=0.80, alpha2=0.04
## with accrual duration of 2 years, study duration of 6 years, power=0.95, pe=0.60 and 
## default values i.e look=1, fup=0, dropout=0, dqol=0

nc3 <- ncoprimary(design=c(2),Survhyp1=c(1,4,0.65,0.75,0.75),Survhyp2=c(1,5,0.67,0.80,0.80),
alpha1=0.01,alpha2=0.04,duraccrual=2,durstudy=6,power=0.95,pe=0.60)

####################################################################################
################  Design superiority with two co-primary endpoints ################# 
####################################################################################

## - For endpoint 1: 2-year survival rate Sc=0.65 and log hazard equivalence margin delta=0.15 
## and alpha1=0.025
## - For endpoint 2: 1-year survival rate Sc=0.70 and log hazard equivalence margin delta=0.10 
## and alpha2=0.025
## with accrual duration of 3 years, study duration of 5 years, drop out hazard rate of 0.025 
## per arm and default values i.e power=0.80, pe=0.5, look=1, fup=0, dqol=0 

nc4 <- ncoprimary(design=c(3),Survhyp1=c(2,0.15,0.65),Survhyp2=c(1,0.10,0.70),alpha1=0.025,
alpha2=0.025,duraccrual=3,durstudy=5,dropout=c(1,0.025,0.025))


}

