/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.corehunter.data.FrequencyGenotypeData;
import org.jamesframework.core.subset.SubsetSolution;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.DataPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class SimpleFrequencyGenotypeData
extends DataPojo
implements FrequencyGenotypeData {
    private static final long serialVersionUID = 1L;
    private static final double SUM_TO_ONE_PRECISION = 0.01000001;
    private static final String ID_HEADER = "X";
    private static final String NAMES_HEADER = "NAME";
    private static final String ALLELE_NAMES_HEADER = "ALLELE";
    private static final String IDENTIFIERS_HEADER = "ID";
    private static final String SELECTED_HEADER = "SELECTED";
    private final double[][][] alleleFrequencies;
    private final String[] markerNames;
    private final String[][] alleleNames;
    private final int totalNumberAlleles;

    public SimpleFrequencyGenotypeData(SimpleEntity[] itemHeaders, String[] markerNames, String[][] alleleNames, double[][][] alleleFrequencies) {
        this("Allele frequency data", itemHeaders, markerNames, alleleNames, alleleFrequencies);
    }

    public SimpleFrequencyGenotypeData(String datasetName, SimpleEntity[] itemHeaders, String[] markerNames, String[][] alleleNames, double[][][] alleleFrequencies) {
        super(datasetName, itemHeaders);
        int j;
        int i;
        int n = alleleFrequencies.length;
        int m = -1;
        int[] numberOfAllelesForMarker = null;
        for (i = 0; i < n; ++i) {
            double[][] indFreqs = alleleFrequencies[i];
            if (indFreqs == null) {
                throw new IllegalArgumentException("Allele frequencies not defined for individual " + i);
            }
            if (m == -1) {
                m = indFreqs.length;
                numberOfAllelesForMarker = new int[m];
                Arrays.fill(numberOfAllelesForMarker, -1);
            } else if (indFreqs.length != m) {
                throw new IllegalArgumentException("All individuals should have same number of markers.");
            }
            for (int j2 = 0; j2 < m; ++j2) {
                double[] alleleFreqs = indFreqs[j2];
                if (alleleFreqs == null) {
                    throw new IllegalArgumentException(String.format("Allele frequencies not defined for individual %d at marker %d.", i, j2));
                }
                if (numberOfAllelesForMarker[j2] == -1) {
                    numberOfAllelesForMarker[j2] = alleleFreqs.length;
                } else if (alleleFreqs.length != numberOfAllelesForMarker[j2]) {
                    throw new IllegalArgumentException("Number of alleles per marker should be consistent across all individuals.");
                }
                if (Arrays.stream(alleleFreqs).anyMatch(f -> f < 0.0)) {
                    throw new IllegalArgumentException("All frequencies should be positive.");
                }
                double sum = Arrays.stream(alleleFreqs).filter(f -> !Double.isNaN(f)).sum();
                if (sum > 1.01000001) {
                    throw new IllegalArgumentException("Allele frequency sum per marker should not exceed one.");
                }
                if (!Arrays.stream(alleleFreqs).noneMatch(Double::isNaN)) continue;
                if (1.0 - sum > 0.01000001) {
                    throw new IllegalArgumentException("Allele frequencies for marker should sum to one.");
                }
                int k = 0;
                while (k < alleleFreqs.length) {
                    int n2 = k++;
                    alleleFreqs[n2] = alleleFreqs[n2] / sum;
                }
            }
        }
        this.totalNumberAlleles = Arrays.stream(numberOfAllelesForMarker).sum();
        this.alleleFrequencies = new double[n][m][];
        for (i = 0; i < n; ++i) {
            for (int j3 = 0; j3 < m; ++j3) {
                this.alleleFrequencies[i][j3] = Arrays.copyOf(alleleFrequencies[i][j3], numberOfAllelesForMarker[j3]);
            }
        }
        if (markerNames == null) {
            this.markerNames = new String[m];
        } else {
            if (markerNames.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of marker names provided. Expected: %d, actual: %d.", m, markerNames.length));
            }
            this.markerNames = Arrays.copyOf(markerNames, m);
        }
        this.alleleNames = new String[m][];
        if (alleleNames == null) {
            for (j = 0; j < m; ++j) {
                this.alleleNames[j] = new String[numberOfAllelesForMarker[j]];
            }
        } else {
            if (alleleNames.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of marker-allele names provided. Expected: %d, actual: %d.", m, alleleNames.length));
            }
            for (j = 0; j < m; ++j) {
                if (alleleNames[j] == null) {
                    this.alleleNames[j] = new String[numberOfAllelesForMarker[j]];
                    continue;
                }
                if (alleleNames[j].length != numberOfAllelesForMarker[j]) {
                    throw new IllegalArgumentException(String.format("Incorrect number of allele names provided for marker %d. Expected: %d, actual: %d.", j, numberOfAllelesForMarker[j], alleleNames[j].length));
                }
                this.alleleNames[j] = Arrays.copyOf(alleleNames[j], numberOfAllelesForMarker[j]);
            }
        }
    }

    @Override
    public int getNumberOfMarkers() {
        return this.markerNames.length;
    }

    @Override
    public int getNumberOfAlleles(int markerIndex) {
        return this.alleleNames[markerIndex].length;
    }

    @Override
    public String getMarkerName(int markerIndex) {
        return this.markerNames[markerIndex];
    }

    @Override
    public int getTotalNumberOfAlleles() {
        return this.totalNumberAlleles;
    }

    @Override
    public String getAlleleName(int markerIndex, int alleleIndex) {
        return this.alleleNames[markerIndex][alleleIndex];
    }

    @Override
    public double getAlleleFrequency(int id, int markerIndex, int alleleIndex) {
        return this.alleleFrequencies[id][markerIndex][alleleIndex];
    }

    @Override
    public boolean hasMissingValues(int id, int markerIndex) {
        return Arrays.stream(this.alleleFrequencies[id][markerIndex]).anyMatch(Double::isNaN);
    }

    public static FrequencyGenotypeData readData(Path filePath, FileType fileType) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        Throwable throwable = null;
        try (RowReader reader = IOUtilities.createRowReader(filePath, fileType, 16, 8, 32);){
            LinkedHashMap<String, Integer> markers;
            int numCols;
            int numDataCols;
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            reader.nextRow();
            String[] markerNamesRow = reader.getRowCellsAsStringArray();
            if (markerNamesRow.length < 1 || !Objects.equals(markerNamesRow[0], IDENTIFIERS_HEADER)) {
                throw new IOException("Missing header row/column ID.");
            }
            boolean withNames = markerNamesRow.length >= 2 && Objects.equals(markerNamesRow[1], NAMES_HEADER);
            int numHeaderCols = 1;
            if (withNames) {
                ++numHeaderCols;
            }
            if ((numDataCols = (numCols = markerNamesRow.length) - numHeaderCols) == 0) {
                throw new IOException("No data columns.");
            }
            markerNamesRow = (String[])Arrays.stream(markerNamesRow).skip(numHeaderCols).toArray(String[]::new);
            try {
                markers = SimpleFrequencyGenotypeData.inferMarkerNames(markerNamesRow);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
            String[] markerNames = ((HashMap)markers).keySet().toArray(new String[0]);
            Integer[] alleleCounts = ((HashMap)markers).values().toArray(new Integer[0]);
            int numMarkers = markers.size();
            String[][] alleleNames = null;
            ArrayList<String> itemNames = new ArrayList<String>();
            ArrayList<String> itemIdentifiers = new ArrayList<String>();
            ArrayList<double[][]> alleleFreqs = new ArrayList<double[][]>();
            int r = 1;
            while (reader.nextRow()) {
                String[] row = reader.getRowCellsAsStringArray();
                if (row.length != numCols) {
                    throw new IOException(String.format("Incorrect number of columns at row %d. Expected: %d, actual: %d.", r, numCols, row.length));
                }
                if (Objects.equals(row[0], ALLELE_NAMES_HEADER)) {
                    if (r != 1) {
                        throw new IOException("Allele names header should be the second row in the file.");
                    }
                    int aglob = numHeaderCols;
                    alleleNames = new String[numMarkers][];
                    for (int m = 0; m < numMarkers; ++m) {
                        alleleNames[m] = new String[alleleCounts[m].intValue()];
                        for (int a = 0; a < alleleNames[m].length; ++a) {
                            alleleNames[m][a] = row[aglob];
                            ++aglob;
                        }
                    }
                } else {
                    itemIdentifiers.add(row[0]);
                    if (withNames) {
                        itemNames.add(row[1]);
                    }
                    double[][] freqsPerMarker = new double[numMarkers][];
                    int fglob = numHeaderCols;
                    for (int m = 0; m < numMarkers; ++m) {
                        freqsPerMarker[m] = new double[alleleCounts[m].intValue()];
                        for (int f = 0; f < freqsPerMarker[m].length; ++f) {
                            double freq;
                            try {
                                freq = row[fglob] == null ? Double.NaN : Double.parseDouble(row[fglob]);
                            }
                            catch (NumberFormatException ex) {
                                throw new IOException(String.format("Invalid frequency at row %d, column %d. Expected double value, got: \"%s\".", r, fglob, row[fglob]), ex);
                            }
                            freqsPerMarker[m][f] = freq;
                            ++fglob;
                        }
                    }
                    alleleFreqs.add(freqsPerMarker);
                }
                ++r;
            }
            int n = alleleFreqs.size();
            if (n == 0) {
                throw new IOException("No data rows.");
            }
            SimpleEntity[] headers = new SimpleEntity[n];
            for (int i = 0; i < n; ++i) {
                String identifier = (String)itemIdentifiers.get(i);
                String name = withNames ? (String)itemNames.get(i) : (String)itemIdentifiers.get(i);
                headers[i] = name != null ? new SimpleEntityPojo(identifier, name) : new SimpleEntityPojo(identifier);
            }
            double[][][] alleleFreqsArray = (double[][][])alleleFreqs.stream().toArray(k -> new double[k][][]);
            try {
                SimpleFrequencyGenotypeData identifier = new SimpleFrequencyGenotypeData(filePath.getFileName().toString(), headers, markerNames, alleleNames, alleleFreqsArray);
                return identifier;
            }
            catch (IllegalArgumentException ex) {
                try {
                    throw new IOException(ex.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static LinkedHashMap<String, Integer> inferMarkerNames(String[] columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("Column names undefined.");
        }
        LinkedHashMap<String, Integer> markerNames = new LinkedHashMap<String, Integer>();
        String curName = null;
        for (int c = 0; c < columnNames.length; ++c) {
            String columnName = columnNames[c];
            if (columnName == null) {
                throw new IllegalArgumentException("Missing column name for data column " + c + ".");
            }
            String markerName = SimpleFrequencyGenotypeData.inferMarkerName(columnName);
            if (markerName.equals("")) {
                throw new IllegalArgumentException(String.format("Invalid marker name at data column %d (%s).", c, columnName));
            }
            if (curName == null || !markerName.equals(curName)) {
                if (markerNames.containsKey(markerName)) {
                    throw new IllegalArgumentException("Duplicate marker name: " + markerName + ". " + "Columns corresponding to same marker should occur consecutively.");
                }
                markerNames.put(markerName, 1);
                curName = markerName;
                continue;
            }
            markerNames.put(markerName, markerNames.get(markerName) + 1);
        }
        return markerNames;
    }

    private static String inferMarkerName(String columnName) {
        int i = Stream.of(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.')).mapToInt(suf -> columnName.lastIndexOf(suf.charValue())).max().orElse(-1);
        String markerName = i >= 0 ? columnName.substring(0, i) : columnName;
        return markerName;
    }

    @Override
    public void writeData(Path filePath, FileType fileType, SubsetSolution solution, boolean includeSelected, boolean includeUnselected, boolean includeIndex) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (filePath.toFile().exists()) {
            throw new IOException("File already exists: " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        if (solution == null) {
            throw new NullPointerException("Solution must be defined");
        }
        if (!solution.getAllIDs().equals(this.getIDs())) {
            throw new IllegalArgumentException("Solution ids must match data.");
        }
        if (!includeSelected && !includeUnselected) {
            throw new IllegalArgumentException("At least one of 'includeSelected' or 'includeUnselected' must be used.");
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        boolean markSelection = includeSelected && includeUnselected;
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 3);){
            Set<Integer> includedIDs;
            int i;
            if (writer == null || !writer.ready()) {
                throw new IOException("Can not create writer for file " + filePath + ".");
            }
            if (includeIndex) {
                writer.writeCell(ID_HEADER);
                writer.newColumn();
            }
            writer.writeCell(IDENTIFIERS_HEADER);
            writer.newColumn();
            writer.writeCell(NAMES_HEADER);
            if (markSelection) {
                writer.newColumn();
                writer.writeCell(SELECTED_HEADER);
            }
            for (i = 0; i < this.markerNames.length; ++i) {
                for (int j = 0; j < this.alleleNames[i].length; ++j) {
                    writer.newColumn();
                    writer.writeCell(this.markerNames[i]);
                }
            }
            writer.newRow();
            if (includeIndex) {
                writer.newColumn();
            }
            writer.writeCell(ALLELE_NAMES_HEADER);
            writer.newColumn();
            if (markSelection) {
                writer.newColumn();
            }
            for (i = 0; i < this.alleleNames.length; ++i) {
                writer.newColumn();
                writer.writeRowCellsAsArray(this.alleleNames[i]);
            }
            if (markSelection) {
                includedIDs = this.getIDs();
            } else if (includeSelected) {
                includedIDs = solution.getSelectedIDs();
            } else if (includeUnselected) {
                includedIDs = solution.getUnselectedIDs();
            } else {
                throw new IllegalArgumentException("One of 'includeSelected' or 'includeUnselected' must be used.");
            }
            ArrayList<Integer> sortedIDs = new ArrayList<Integer>(includedIDs);
            sortedIDs.sort(null);
            Set<Integer> selected = solution.getSelectedIDs();
            Iterator iterator = sortedIDs.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                writer.newRow();
                if (includeIndex) {
                    writer.writeCell(id);
                    writer.newColumn();
                }
                SimpleEntity header = this.getHeader(id);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                if (markSelection) {
                    writer.newColumn();
                    writer.writeCell(selected.contains(id));
                }
                for (int m = 0; m < this.alleleFrequencies[id].length; ++m) {
                    for (int a = 0; a < this.alleleFrequencies[id][m].length; ++a) {
                        writer.newColumn();
                        double freq = this.alleleFrequencies[id][m][a];
                        writer.writeCell(Double.isNaN(freq) ? null : Double.valueOf(freq));
                    }
                }
            }
            writer.close();
        }
    }
}

