% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot3d.corregp}
\alias{plot3d.corregp}
\title{3D Plotting for Correspondence Regression}
\usage{
\method{plot3d}{corregp}(x, axes = 1:3, y_btm = TRUE, y_ell = FALSE,
  x_ell = FALSE, ysub = NULL, xsub = NULL, hlim = NULL, vlim = NULL,
  dlim = NULL, asp = par3d("scale"), col_btm = "darkgrey",
  col_top = "red", cex_btm = par3d("cex"), cex_top = cex_btm,
  font_btm = par3d("font"), font_top = font_btm, col_ell = "black",
  lwd_ell = 1, lty_ell = "shade", opa_ell = 0.2, col_ori = "grey",
  lwd_ori = 1, main = NULL, sub = NULL, hlab = NULL, vlab = NULL,
  dlab = NULL, cl = 0.95, add_ori = TRUE, ...)
}
\arguments{
\item{x}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{axes}{The axes to plot: a vector of three values. Defaults to the first three axes.}

\item{y_btm}{Logical specifying whether the Y levels should be plotted first ("at the bottom") and then be overlaid by the X levels. Defaults to \code{TRUE}.}

\item{y_ell}{Logical specifying whether the confidence ellipsoids of the Y levels should be plotted. Defaults to \code{FALSE}.}

\item{x_ell}{Logical specifying whether the confidence ellipsoids of the X levels should be plotted. Defaults to \code{FALSE}.}

\item{ysub}{Vector of indices to select a subset of the Y levels.}

\item{xsub}{Vector of indices to select a subset of the X levels.}

\item{hlim}{Vector of two values specifying the lower and upper limit between which to plot the horizontal axis.}

\item{vlim}{Vector of two values specifying the lower and upper limit between which to plot the vertical axis.}

\item{dlim}{Vector of two values specifying the lower and upper limit between which to plot the "depth" axis.}

\item{asp}{The aspect ratio for the whole plot. See \code{\link[rgl]{aspect3d}}.}

\item{col_btm}{Color of the bottom levels: either \code{numeric} or see \code{\link[grDevices]{colors}}. Defaults to \code{"darkgrey"}.}

\item{col_top}{Color of the top levels: either \code{numeric} or see \code{\link[grDevices]{colors}}. Defaults to \code{"red"}.}

\item{cex_btm}{Character expansion factor of the bottom levels: a number to specify the size of the text labels.}

\item{cex_top}{Character expansion factor of the top levels: a number to specify the size of the text labels.}

\item{font_btm}{Font of the bottom levels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic.}

\item{font_top}{Font of the top levels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic.}

\item{col_ell}{Color of the confidence ellipsoids: either a number or see \code{\link[grDevices]{colors}}. Defaults to \code{"black"}.}

\item{lwd_ell}{Width of the confidence ellipsoids: a number to specify the line width.}

\item{lty_ell}{Line type of the confidence ellipsoids: either \code{"shade"}, \code{"wire"}, or \code{"dots"}. Defaults to \code{"shade"}.}

\item{opa_ell}{Opaqueness of the confidence ellipsoids: a number between \code{0} for fully transparant and \code{1} for fully opaque. Defaults to \code{0.2}.}

\item{col_ori}{Color of the lines through the origin: either a number or see \code{\link[grDevices]{colors}}. Defaults to \code{"grey"}.}

\item{lwd_ori}{Width of the lines through the origin: a number to specify the line width. Defaults to \code{1}.}

\item{main}{The main title of the plot.}

\item{sub}{The subtitle of the plot.}

\item{hlab}{The title of the horizontal axis.}

\item{vlab}{The title of the vertical axis.}

\item{dlab}{The title of the "depth" axis.}

\item{cl}{The confidence level for the confidence ellipsoids. Defaults to \code{0.95}.}

\item{add_ori}{Logical specifying whether to add lines through the origin. Defaults to \code{TRUE}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A 3D plot window containing the output of a correspondence regression.
}
\description{
Method to produce a 3D plot for a correspondence regression.
}
\details{
\code{plot3d} (of a \code{corregp} output) makes use of \code{\link[rgl]{plot3d}} (and \code{\link[rgl]{text3d}} and \code{\link[rgl]{abclines3d}}) from the package \pkg{rgl}.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
plot3d(haireye.crg, x_ell = TRUE, xsub = c("Hair", "Sex"))
\donttest{play3d(spin3d())}
}
\seealso{
\code{\link{corregp}}, \code{\link[rgl]{plot3d}}.
}

