% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\docType{data}
\name{HairEye}
\alias{HairEye}
\title{Hair and Eye Color of Statistics Students (Data Frame)}
\format{A data frame with 592 rows and 3 variables.}
\source{
This is simply a data frame version of the in-built data set \code{\link[datasets]{HairEyeColor}}.
}
\description{
The distribution of hair color, eye color and sex among 592 statistics students (from Snee 1974 and Friendly 1992).
}
\examples{
\dontrun{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
haireye.crg
summary(haireye.crg, parm = "b", add_ci = TRUE)
screeplot(haireye.crg, add_ci = TRUE)
anova(haireye.crg, nf = 2)
plot(haireye.crg, x_ell = TRUE, xsub = c("Hair", "Sex"))
}
}
