% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrio.R
\name{corrio}
\alias{corrio}
\title{Apply and visualize Pearson's product-moment correlation.}
\usage{
corrio(data = NULL, visualize = TRUE)
}
\arguments{
\item{data}{A data.frame with two columns, which shall be correlated by Pearson's product-moment method.}

\item{visualize}{A single boolean value (default: TRUE), which determines whether the data shall be visualized.}
}
\value{
a list with a data.frame (name: dat), a list (name: details), and two graphs as elements (plot1 and plot2).
dat contains these five columns:
\enumerate{
\item x Values of the first variable (= x).
\item y Values of the second variable (= y).
\item x-mean(x) Difference between x and the mean of x.
\item y-mean(y) Difference between y and the mean of y.
\item covVec Product of x-mean(x) and y-mean(y).
}

details is a list with 12 objects, each of which contains an explanation as attribute:
\enumerate{
\item Mean of variable 1 (variable 1 = x).
\item Mean of variable 2 (variable 2 = y).
\item Sum of all negative products (negSum): (x-mean(x)) * (y-mean(y)).
\item Sum of all positive products (posSum): (x-mean(x)) * (y-mean(y)).
\item Numerator of covariance formula: Sum of negSum and posSum.
\item Denominator of covariance formula: n - 1.
\item Covariance: numeratorCov/denominatorCov.
\item Standard deviation of variable 1 (i.e., x): R command sd().
\item Standard deviation of variable 2 (i.e., y): R command sd().
\item Product of standard deviations (prodSD) of variables 1 and 2 (i.e., x and y).
\item Correlation: Covariance/prodSD.
\item Percentages of pairwise directions of s, c, n (s = same, c = contrary, n = no)
}
plot1 and plot2 are two ways of visualizing the connection between the individual values and their respective mean value.
}
\description{
Compute all components which are part of Pearson's correlation coefficient and visualize the most important part of what is summarized in the correlation coefficient. This most important part is the difference between the values of each variable from their respective mean. While it may appear superflous for some people to visualize this part, other people may benefit from it. See vignette of this 'correlatio' package for further explanations.
}
\examples{
simData <- simcor(obs=100, rhos = .6)
corrio(data=simData[[1]], visualize = TRUE)
}
\references{
\insertRef{curran2010explorations}{correlatio}

\insertRef{wickham2016programming}{correlatio}
}
\author{
Marcel Miché
}
