% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_countries.R
\name{list_countries}
\alias{list_countries}
\title{Get a list of country names}
\usage{
list_countries(nomenclature = "name_en")
}
\arguments{
\item{nomenclature}{String indicating the nomenclature from which the list of countries should be taken. Not all countries are present in all nomenclatures, for example Taiwan is not recognised by the UN, so it will not be returned with \code{"WTO_en"}. The function accepts any of the nomenclatures supported country_name. For a list of accepted values, refer to \href{https://fbellelli.github.io/countries/articles/dealing_with_names.html}{this page}. The default is \code{name_en}, which is the English list of names in the ISO standard 3166.}
}
\value{
A vector of country names in the desired nomenclature.
}
\description{
This function returns a vector of country names in different nomenclatures.
}
\examples{
list_countries("ISO3")
list_countries("UN_en")
list_countries()
}
\seealso{
\link[countries]{random_countries}, \link[countries]{country_name}
}
