% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tesseract.R
\name{tesseract}
\alias{tesseract}
\alias{tesseract_params}
\alias{tesseract_info}
\title{Tesseract Engine}
\usage{
tesseract(
  language = "eng",
  datapath = NULL,
  configs = NULL,
  options = NULL,
  cache = TRUE
)

tesseract_params(filter = "")

tesseract_info()
}
\arguments{
\item{language}{string with language for training data. Usually defaults to \code{eng}}

\item{datapath}{path with the training data for this language. Default uses
the system library.}

\item{configs}{character vector with files, each containing one or more parameter
values. These config files can exist in the current directory or one of the standard
tesseract config files that live in the tessdata directory. See details.}

\item{options}{a named list with tesseract parameters. See details.}

\item{cache}{speed things up by caching engines}

\item{filter}{only list parameters containing a particular string}
}
\value{
no return value, called for side effects

no return value, called for side effects

list with information about the tesseract engine
}
\description{
Create an OCR engine for a given language and control parameters. This can be used by
the \link{ocr} and \link{ocr_data} functions to recognize text.
}
\details{
Tesseract control parameters can be set either via a named list in the
\code{options} parameter, or in a \code{config} file text file which contains the parameter name
followed by a space and then the value, one per line. Use \code{\link[=tesseract_params]{tesseract_params()}} to list
or find parameters. Note that that some parameters are only supported in certain versions
of libtesseract, and that invalid parameters can sometimes cause libtesseract to crash.
}
\examples{
tesseract_params("debug")
}
\seealso{
Other tesseract: 
\code{\link{ocr}()},
\code{\link{tesseract_download}()}
}
\concept{tesseract}
