% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocr.R
\name{ocr}
\alias{ocr}
\alias{ocr_data}
\title{Tesseract OCR}
\usage{
ocr(file, engine = tesseract("eng"), HOCR = FALSE, opw = "", upw = "")

ocr_data(file, engine = tesseract("eng"))
}
\arguments{
\item{file}{file path or raw vector (png, tiff, jpeg, etc).}

\item{engine}{a tesseract engine created with \code{\link[=tesseract]{tesseract()}}. Alternatively a
language string which will be passed to \code{\link[=tesseract]{tesseract()}}.}

\item{HOCR}{if \code{TRUE} return results as HOCR xml instead of plain text}

\item{opw}{owner password to open pdf (please pass it as an environment
variable to avoid leaking sensitive information)}

\item{upw}{user password to open pdf (please pass it as an environment
variable to avoid leaking sensitive information)}
}
\value{
character vector of text extracted from the file. If the file
is has TIFF or PDF extension, it will be a vector of length equal to the
number of pages.
}
\description{
Extract text from an image. Requires that you have training data for the language you
are reading. Works best for images with high contrast, little noise and horizontal text.
See \href{https://github.com/tesseract-ocr/tessdoc}{tesseract wiki} and
the package vignette for image preprocessing tips.
}
\details{
The \code{ocr()} function returns plain text by default, or hOCR text if hOCR is set to \code{TRUE}.
The \code{ocr_data()} function returns a data frame with a confidence rate and bounding box for
each word in the text.
}
\examples{
file <- system.file("examples", "test.png", package = "cpp11tesseract")
text <- ocr(file)
cat(text)
}
\references{
\href{https://github.com/tesseract-ocr/tesseract/wiki/ImproveQuality}{Tesseract: Improving Quality}
}
\seealso{
Other tesseract: 
\code{\link{tesseract}()},
\code{\link{tesseract_download}()}
}
\concept{tesseract}
