% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.R
\name{erase}
\alias{erase}
\alias{erase,CppSet-method}
\alias{erase,CppUnorderedSet-method}
\alias{erase,CppMultiset-method}
\alias{erase,CppUnorderedMultiset-method}
\alias{erase,CppMap-method}
\alias{erase,CppUnorderedMap-method}
\alias{erase,CppMultimap-method}
\alias{erase,CppUnorderedMultimap-method}
\alias{erase,CppVector-method}
\alias{erase,CppDeque-method}
\alias{erase,CppList-method}
\title{Erase elements}
\usage{
erase(x, values = NULL, from = NULL, to = NULL)
}
\arguments{
\item{x}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, CppUnorderedMultimap, CppVector, CppDeque, 
or CppList object.}

\item{values}{A vector of values to delete from \code{x} in CppSet, CppUnorderedSet, CppMultiset, and CppUnorderedMultiset objects and keys in CppMap, 
CppUnorderedMap, CppMultimap, and CppUnorderedMultimap objects. Ignored for other classes.}

\item{from}{Index of the first element to be deleted in CppVector, CppDeque, and CppList objects. Ignored for other classes.}

\item{to}{Index of the last element to be deleted in CppVector, CppDeque, and CppList objects. Ignored for other classes.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Delete elements from a container by reference.
}
\examples{
s <- cpp_multiset(c(2, 2.1, 3, 3, 4.3, 6))
s
# 2 2.1 3 3 4.3 6

erase(s, c(2, 3))
s
# 2.1 4.3 6

m <- cpp_unordered_multimap(c(2:3, 3L), c("hello", "there", "world"))
m
# [3,"world"] [3,"there"] [2,"hello"]

erase(m, 2L)
m
# [3,"world"] [3,"there"]

d <- cpp_deque(4:9)
d
# 4 5 6 7 8 9

erase(d, from = 2, to = 3)
d
# 4 7 8 9

}
\seealso{
\link{clear}, \link{empty}, \link{erase_after}, \link{remove.}.
}
