% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dep.R
\name{get_dep}
\alias{get_dep}
\alias{get_dep_all}
\title{One type of dependencies of a package}
\usage{
get_dep(name, type, scrape = TRUE)

get_dep_all(name, type, scrape = TRUE)
}
\arguments{
\item{name}{String, name of the package}

\item{type}{One of the following dependency words: "Depends", "Imports", "LinkingTo", "Suggests", "Reverse depends", "Reverse imports", "Reverse linking to", "Reverse suggests", up to letter case and space replaced by underscore}

\item{scrape}{Boolean. If 'TRUE' (default), the page of the package will be scraped. If 'FALSE', tools::CRAN_package_db() will be used. Whether the argument equals 'TRUE' or 'FALSE' should not affect the output, but only the time taken. Usually, the former is faster than the latter for a single package.}
}
\value{
A string vector of dependencies
}
\description{
\code{get_dep} returns, in a vector, one type of dependencies of a package directly
}
\examples{
get_dep("dplyr", "Imports")
get_dep("MASS", "Depends", TRUE) # FALSE will give same result
}
