% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{xgb_params}
\alias{xgb_params}
\title{Logistic Regression & Scorecard Parameters}
\usage{
xgb_params(nrounds = 1000, params = list(max.depth = 6, eta = 0.1,
  min_child_weight = 1, subsample = 1, colsample_bytree = 1, gamma = 0,
  max_delta_step = 0, eval_metric = "auc", objective = "binary:logistic"),
  early_stopping_rounds = 100, ...)
}
\arguments{
\item{nrounds}{Max number of boosting iterations.}

\item{params}{A list contains parameters of xgboost.The complete list of parameters is available at: \url{ http://xgboost.readthedocs.io/en/latest/parameter.html}}

\item{early_stopping_rounds}{If NULL, the early stopping function is not triggered. If set to an integer k, training with a validation set will stop if the performance doesn't improve for k rounds.}

\item{...}{Other parameters}
}
\value{
A list of parameters.
}
\description{
\code{xgb_params} is the list of parameters to train a LR model or Scorecard using in \code{\link{training_model}}.
}
\seealso{
\code{\link{training_model}}, \code{\link{lr_params}},\code{\link{gbm_params}}, \code{\link{rf_params}}
}
