% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process_tools.R
\name{rowAny}
\alias{rowAny}
\alias{rowAllnas}
\alias{colAllnas}
\alias{colAllzeros}
\alias{rowAll}
\alias{rowCVs}
\alias{rowSds}
\alias{colSds}
\alias{rowMaxs}
\alias{rowMins}
\alias{rowMaxMins}
\alias{colMaxMins}
\title{Functions for vector operation.}
\usage{
rowAny(x)

rowAllnas(x)

colAllnas(x)

colAllzeros(x)

rowAll(x)

rowCVs(x, na.rm = FALSE)

rowSds(x, na.rm = FALSE)

colSds(x, na.rm = TRUE)

rowMaxs(x, na.rm = FALSE)

rowMins(x, na.rm = FALSE)

rowMaxMins(x, na.rm = FALSE)

colMaxMins(x, na.rm = FALSE)
}
\arguments{
\item{x}{A data.frame or Matrix.}

\item{na.rm}{Logical, remove NAs.}
}
\value{
A data.frame or Matrix.
}
\description{
Functions for vector operation.
}
\examples{
#any row has missing values
row_amy =  rowAny(UCICreditCard[8:10])
#rows which is all missing values
row_na =  rowAllnas(UCICreditCard[8:10])
#cols which is all missing values
col_na =  colAllnas(UCICreditCard[8:10])
#cols which is all zeros
row_zero =  colAllzeros(UCICreditCard[8:10])
#sum all numbers of a row
row_all =  rowAll(UCICreditCard[8:10])
#caculate cv of a row
row_cv =  rowCVs(UCICreditCard[8:10])
#caculate sd of a row
row_sd =  rowSds(UCICreditCard[8:10])
#caculate sd of a column
col_sd =  colSds(UCICreditCard[8:10])
}
