% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_selection.R
\name{gbm_filter}
\alias{gbm_filter}
\title{Select Features using GBM}
\usage{
gbm_filter(dat, target = NULL, x_list = NULL, ex_cols = NULL,
  pos_flag = NULL, GBM.params = gbm_params(), cores_num = 2,
  vars_name = TRUE, note = TRUE, save_data = FALSE,
  file_name = NULL, dir_path = tempdir(), seed = 46, ...)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{target}{The name of target variable.}

\item{x_list}{Names of independent variables.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{GBM.params}{Parameters of GBM.The complete list of parameters is available at: \code{\link{gbm}}.}

\item{cores_num}{The number of CPU cores to use.}

\item{vars_name}{Logical, output a list of filtered variables or table with detailed IV and PSI value of each variable. Default is TRUE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{save_data}{Logical, save results results in locally specified folder. Default is FALSE.}

\item{file_name}{The name for periodically saved results files.  Default is "Feature_importance_GBDT".}

\item{dir_path}{The path for periodically saved results files.  Default is "./variable".}

\item{seed}{Random number seed. Default is 46.}

\item{...}{Other parameters to pass to gbdt_params.}
}
\value{
Selected variables.
}
\description{
\code{gbm_filter}  is for selecting important features using GBM.
}
\examples{
GBM.params = gbm_params(n.trees = 2, interaction.depth = 2, shrinkage = 0.1,
                       bag.fraction = 1, train.fraction = 1,
                       n.minobsinnode = 30,
                     cv.folds = 2)
\dontrun{
 features <- gbm_filter(dat = UCICreditCard[1:1000, c(8:12, 26)],
         target = "default.payment.next.month",
      occur_time = "apply_date",
     GBM.params = GBM.params
       , vars_name = FALSE)
}
}
\seealso{
\code{\link{psi_iv_filter}}, \code{\link{xgb_filter}}, \code{\link{feature_selector}}
}
