% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_eval.R
\name{crew_eval}
\alias{crew_eval}
\title{Evaluate an R command and return results as a monad.}
\usage{
crew_eval(
  command,
  name,
  data = list(),
  globals = list(),
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE
)
}
\arguments{
\item{command}{Language object with R code to run.}

\item{name}{Character of length 1, name of the task.}

\item{data}{Named list of local data objects in the evaluation environment.}

\item{globals}{Named list of objects to temporarily assign to the
global environment for the task.}

\item{seed}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{algorithm}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{packages}{Character vector of packages to load for the task.}

\item{library}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to detach any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.
In either case, the namespaces are not detached.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.
for this and other reasons, \code{reset_options} only resets options
that were nonempty at the beginning of the task.
If your task sets an entirely new option not already in \code{options()},
then \code{reset_options = TRUE} does not delete the option.}

\item{garbage_collection}{\code{TRUE} to run garbage collection after each task
task, \code{FALSE} to skip.}
}
\value{
A monad object with results and metadata.
}
\description{
Not a user-side function. Do not call directly.
}
\details{
The \code{crew_eval()} function evaluates an R expression
in an encapsulated environment and returns a monad with the results,
including warnings and error messages if applicable.
The random number generator seed, \code{globals}, and global options
are restored to their original values on exit.
}
\examples{
crew_eval(quote(1 + 1), name = "task_name")
}
\seealso{
Other utility: 
\code{\link{crew_assert}()},
\code{\link{crew_clean}()},
\code{\link{crew_deprecate}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_terminate_process}()},
\code{\link{crew_terminate_signal}()},
\code{\link{crew_worker}()}
}
\concept{utility}
