% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTimelineofWinsLosses.R
\name{plotTimelineofWinsLosses}
\alias{plotTimelineofWinsLosses}
\title{Plot the time line of wins/losses/draw/tied etc for a Team in Test, ODI or T20}
\usage{
plotTimelineofWinsLosses(file,teamName,opposition=c("all"),homeOrAway=c("all"),
      startDate="2001-01-01",endDate="2019-01-01",matchType="Test")
}
\arguments{
\item{file}{The CSV file for which the plot is required}

\item{teamName}{The name of the team for which plot is required}

\item{opposition}{Opposition is a vector namely c("all") or c("Australia", "India", "England")}

\item{homeOrAway}{This parameter is a vector which is either c("all") or a vector of venues c("home","away","neutral")}

\item{startDate}{The start date from which time line is required}

\item{endDate}{The end data for which the time line plot is required}

\item{matchType}{Match type - Test, ODI or T20}
}
\value{
None
}
\description{
This function returns plots a time line of won,lost,draw,tied or no result for a team against
other teams in home/away or neutral venues
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the team data for India for Tests

df <- getTeamDataHomeAway(teamName="India",file="indiaOD.csv",matchType="ODI")
plotTimelineofWinsLosses("indiaOD.csv",teamName="India",
        startDate="2015-01-01",endDate="2019-01-01", matchType="ODI")
}
}
\references{
\url{http://www.espncricinfo.com/ci/content/stats/index.html}\cr
\url{https://gigadom.in/}\cr
}
\seealso{
\code{\link{teamWinLossStatusVsOpposition}}
\code{\link{teamWinLossStatusAtGrounds}}
\code{\link{plotTimelineofWinsLosses}}
}
\author{
Tinniam V Ganesh
}
